/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.astralya.hexalia.block.custom.ShelfBlock;
import net.astralya.hexalia.block.entity.custom.ShelfBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ShelfBlockRenderer
implements BlockEntityRenderer<ShelfBlockEntity> {
    private final ItemRenderer itemRenderer;

    public ShelfBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.m_234447_();
    }

    public void render(@NotNull ShelfBlockEntity shelf, float partialTick, PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = shelf.m_58904_();
        if (level == null) {
            return;
        }
        NonNullList<ItemStack> items = shelf.getItems();
        BlockState state = shelf.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)ShelfBlock.FACING);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-facing.m_122435_()));
        for (int slot = 0; slot < items.size(); ++slot) {
            double xOffset;
            double zOffset;
            ItemStack stack = (ItemStack)items.get(slot);
            if (stack.m_41619_()) continue;
            poseStack.m_85836_();
            double yOffset = 0.45;
            int column = slot % 3;
            int row = slot / 3;
            if (row == 0) {
                zOffset = -0.375;
                xOffset = column == 0 ? -0.34375 : (column == 1 ? 0.0 : 0.34375);
            } else {
                zOffset = -0.125;
                xOffset = column == 0 ? -0.34375 : (column == 1 ? 0.0 : 0.34375);
            }
            poseStack.m_85837_(xOffset, yOffset, zOffset);
            float angleVariation = column * 5 - 5;
            poseStack.m_252781_(Axis.f_252436_.m_252977_(angleVariation));
            float scale = 0.3f;
            poseStack.m_85841_(scale, scale, scale);
            this.itemRenderer.m_269128_(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, buffer, level, 0);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(ShelfBlockEntity blockEntity) {
        return true;
    }
}

