/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.compat.jei.category;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.recipe.SmallCauldronRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class SmallCauldronRecipeCategory
implements IRecipeCategory<SmallCauldronRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("hexalia", "small_cauldron");
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexalia", "textures/gui/small_cauldron_category_gui.png");
    public static final RecipeType<SmallCauldronRecipe> SMALL_CAULDRON_TYPE = new RecipeType(UID, SmallCauldronRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable heatIcon;

    public SmallCauldronRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 118, 80);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.SMALL_CAULDRON.get()));
        this.heatIcon = helper.createDrawable(TEXTURE, 0, 0, 16, 16);
    }

    public RecipeType<SmallCauldronRecipe> getRecipeType() {
        return SMALL_CAULDRON_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.hexalia.small_cauldron");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SmallCauldronRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 31).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 4, 31).addIngredients((Ingredient)recipe.m_7527_().get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 52, 31).addIngredients((Ingredient)recipe.m_7527_().get(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 55).addIngredients(recipe.getBottleSlot());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 89, 31).addItemStack(recipe.m_8043_(null));
    }

    public void draw(SmallCauldronRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.heatIcon.draw(guiGraphics, 28, 7);
    }

    public List<Component> getTooltipStrings(SmallCauldronRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 28.0 && mouseX < 44.0 && mouseY >= 7.0 && mouseY < 23.0) {
            return List.of(Component.m_237115_((String)"tooltip.hexalia.heat"));
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }
}

