/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.astralya.hexalia.recipe.SmallCauldronRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SmallCauldronRecipeBuilder
implements RecipeBuilder {
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final Item result;
    private final Item bottleSlotItem;
    private int brewTime = 200;
    private float experience = 0.0f;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();

    public SmallCauldronRecipeBuilder(List<ItemLike> ingredients, ItemLike bottleSlotItem, ItemLike result) {
        for (ItemLike ingredient : ingredients) {
            this.ingredients.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}));
        }
        this.bottleSlotItem = bottleSlotItem.m_5456_();
        this.result = result.m_5456_();
    }

    public SmallCauldronRecipeBuilder brewTime(int brewTime) {
        this.brewTime = brewTime;
        return this;
    }

    public SmallCauldronRecipeBuilder experience(float experience) {
        this.experience = experience;
        return this;
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.result, this.ingredients, this.bottleSlotItem, this.brewTime, this.experience, this.advancement, new ResourceLocation(pRecipeId.m_135827_(), "recipes/" + pRecipeId.m_135815_())));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final List<Ingredient> ingredients;
        private final Item bottleSlotItem;
        private final int brewTime;
        private final float experience;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Item result, List<Ingredient> ingredients, Item bottleSlotItem, int brewTime, float experience, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.result = result;
            this.ingredients = ingredients;
            this.bottleSlotItem = bottleSlotItem;
            this.brewTime = brewTime;
            this.experience = experience;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.addProperty("type", "hexalia:small_cauldron");
            JsonArray jsonIngredients = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                jsonIngredients.add(ingredient.m_43942_());
            }
            pJson.add("ingredients", (JsonElement)jsonIngredients);
            JsonObject jsonBottleSlot = new JsonObject();
            jsonBottleSlot.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.bottleSlotItem).toString());
            pJson.add("bottle_slot", (JsonElement)jsonBottleSlot);
            JsonObject jsonOutput = new JsonObject();
            jsonOutput.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            pJson.add("output", (JsonElement)jsonOutput);
            pJson.addProperty("brew_time", (Number)this.brewTime);
            pJson.addProperty("experience", (Number)Float.valueOf(this.experience));
        }

        public ResourceLocation m_6445_() {
            return new ResourceLocation("hexalia", ForgeRegistries.ITEMS.getKey((Object)this.result).m_135815_() + "_from_small_cauldron");
        }

        public RecipeSerializer<?> m_6637_() {
            return SmallCauldronRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

