/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.entity.ai.silkmoth;

import java.util.EnumSet;
import net.astralya.hexalia.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class AttractedToLightGoal
extends Goal {
    private final Mob entity;
    private final double speed;
    private BlockPos targetPos;

    public AttractedToLightGoal(Mob entity, double speed) {
        this.entity = entity;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public void m_8056_() {
        if (this.targetPos != null) {
            this.entity.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), this.speed);
        }
    }

    public boolean m_8045_() {
        if (this.entity.m_20096_() && this.isNearLightSource()) {
            this.entity.m_21573_().m_26573_();
            return true;
        }
        return this.targetPos != null && !this.entity.m_21573_().m_26571_();
    }

    public boolean m_8036_() {
        return this.findAttractingLightSource();
    }

    public void m_8041_() {
        this.targetPos = null;
    }

    private boolean findAttractingLightSource() {
        Level world = this.entity.m_9236_();
        BlockPos entityPos = this.entity.m_20183_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int entityX = entityPos.m_123341_();
        int entityY = entityPos.m_123342_();
        int entityZ = entityPos.m_123343_();
        for (int x = -10; x <= 10; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -10; z <= 10; ++z) {
                    mutablePos.m_122178_(entityX + x, entityY + y, entityZ + z);
                    Block block = world.m_8055_((BlockPos)mutablePos).m_60734_();
                    if (!block.m_49966_().m_204336_(ModTags.Blocks.ATTRACTS_MOTH)) continue;
                    this.targetPos = mutablePos.m_7949_();
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isNearLightSource() {
        return this.targetPos != null && this.entity.m_20183_().m_123314_((Vec3i)this.targetPos, 1.5);
    }
}

