/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.entity.ai.silkmoth;

import java.util.EnumSet;
import net.astralya.hexalia.entity.custom.SilkMothEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FlyWanderGoal
extends Goal {
    private final SilkMothEntity moth;
    private final double speed;
    private int cooldown;
    private static final int ATTEMPTS = 12;
    private static final double H_RANGE = 8.0;
    private static final double V_MIN = 0.5;
    private static final double V_MAX = 3.0;

    public FlyWanderGoal(SilkMothEntity moth, double speed) {
        this.moth = moth;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.moth.m_21523_() || this.moth.m_20159_()) {
            return false;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        return this.moth.m_21573_().m_26571_();
    }

    public boolean m_8045_() {
        return !this.moth.m_21573_().m_26571_();
    }

    public void m_8056_() {
        Vec3 target = this.findAirTarget();
        if (target != null) {
            this.moth.m_21573_().m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, this.speed);
        }
        this.cooldown = 12 + this.moth.m_217043_().m_188503_(12);
    }

    private Vec3 findAirTarget() {
        Level level = this.moth.m_9236_();
        Vec3 base = this.moth.m_20182_();
        RandomSource rng = this.moth.m_217043_();
        for (int i = 0; i < 12; ++i) {
            double dx = (rng.m_188500_() - 0.5) * 2.0 * 8.0;
            double dz = (rng.m_188500_() - 0.5) * 2.0 * 8.0;
            double dy = 0.5 + rng.m_188500_() * 2.5;
            Vec3 candidate = base.m_82520_(dx, dy, dz);
            BlockPos pos = BlockPos.m_274446_((Position)candidate);
            if (!level.m_46749_(pos) || !level.m_8055_(pos).m_60795_()) continue;
            Vec3 delta = candidate.m_82546_(base);
            AABB movedBox = this.moth.m_20191_().m_82383_(delta);
            if (!level.m_45756_((Entity)this.moth, movedBox)) continue;
            BlockPos below = pos.m_7495_();
            if (!level.m_8055_(below).m_60795_()) {
                candidate = candidate.m_82520_(0.0, 0.75, 0.0);
                delta = candidate.m_82546_(base);
                movedBox = this.moth.m_20191_().m_82383_(delta);
                if (!level.m_45756_((Entity)this.moth, movedBox)) continue;
            }
            return candidate;
        }
        double dx = (rng.m_188500_() - 0.5) * 4.0;
        double dz = (rng.m_188500_() - 0.5) * 4.0;
        double dy = 0.5 + rng.m_188500_();
        return base.m_82520_(dx, dy, dz);
    }
}

