/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.entity.custom.projectile;

import java.util.List;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.entity.ModEntities;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.sound.ModSoundEvents;
import net.astralya.hexalia.util.ModUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;

public class PurifyingSacProjectile
extends ThrowableItemProjectile {
    public PurifyingSacProjectile(EntityType<? extends PurifyingSacProjectile> type, Level level) {
        super(type, level);
    }

    public PurifyingSacProjectile(Level level) {
        super((EntityType)ModEntities.PURIFYING_SAC.get(), level);
    }

    public PurifyingSacProjectile(Level level, LivingEntity owner) {
        super((EntityType)ModEntities.PURIFYING_SAC.get(), owner, level);
    }

    protected Item m_7881_() {
        return (Item)ModItems.PURIFYING_SAC.get();
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected void m_6532_(HitResult hit) {
        super.m_6532_(hit);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSoundEvents.SAC_IMPACT.get(), SoundSource.PLAYERS, 0.9f, 0.8f + this.m_9236_().m_213780_().m_188501_() * 0.4f);
            this.spawnLingeringCloudAndCleanse();
            this.m_146870_();
        }
    }

    private void spawnLingeringCloudAndCleanse() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        int durationSeconds = Math.max(1, (Integer)Configuration.PURIFYING_SAC_DURATION.get());
        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            cloud.m_19718_(le);
        }
        cloud.m_19712_(3.0f);
        cloud.m_19738_(-3.0f / ((float)durationSeconds * 20.0f));
        cloud.m_19734_(durationSeconds * 20);
        cloud.m_19740_(0);
        cloud.m_19724_((ParticleOptions)ParticleTypes.f_123811_);
        cloud.m_19714_(13625855);
        float r = cloud.m_19743_();
        AABB aabb = new AABB(this.m_20185_() - (double)r, this.m_20186_() - 1.0, this.m_20189_() - (double)r, this.m_20185_() + (double)r, this.m_20186_() + 1.0, this.m_20189_() + (double)r);
        List targets = this.m_9236_().m_45976_(LivingEntity.class, aabb);
        for (LivingEntity target : targets) {
            double dz;
            double dx = target.m_20185_() - this.m_20185_();
            if (!(dx * dx + (dz = target.m_20189_() - this.m_20189_()) * dz <= (double)(r * r))) continue;
            ModUtil.removeHarmfulEffects(target);
        }
        this.m_9236_().m_7967_((Entity)cloud);
    }
}

