/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.item.custom;

import java.util.List;
import java.util.function.Supplier;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.item.custom.AbstractConsumableItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BrewItem
extends AbstractConsumableItem {
    private final int durationTicks;
    private final int baseAmplifier;
    private final Component baseTooltip;
    private final Supplier<MobEffect> effectSupplier;

    public BrewItem(Item.Properties properties, Supplier<MobEffect> effectSupplier, int durationTicks, int amplifier, Component tooltip) {
        super(properties);
        this.effectSupplier = effectSupplier;
        this.durationTicks = Math.max(0, durationTicks);
        this.baseAmplifier = Math.max(0, amplifier);
        this.baseTooltip = tooltip;
    }

    @Override
    protected void handleEffects(Level level, LivingEntity user, ItemStack consumedStack) {
        if (!level.m_5776_()) {
            user.m_7292_(new MobEffectInstance(this.effectSupplier.get(), this.durationTicks, this.baseAmplifier));
        }
    }

    @Override
    protected ItemStack getReturnContainer(ItemStack consumedStack) {
        return new ItemStack((ItemLike)ModItems.RUSTIC_BOTTLE.get());
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add(this.baseTooltip);
    }
}

