/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class SmallCauldronRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    private final Ingredient bottleSlot;
    private final int brewTime;
    private final float experience;

    public SmallCauldronRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, Ingredient bottleSlot, int brewTime, float experience) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
        this.bottleSlot = bottleSlot;
        this.brewTime = brewTime;
        this.experience = experience;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.m_5776_()) {
            return false;
        }
        boolean[] slotsMatched = new boolean[container.m_6643_()];
        for (Ingredient ingredient : this.recipeItems) {
            boolean foundIngredient = false;
            for (int i = 0; i < container.m_6643_() - 1; ++i) {
                if (slotsMatched[i] || !ingredient.test(container.m_8020_(i))) continue;
                slotsMatched[i] = true;
                foundIngredient = true;
                break;
            }
            if (foundIngredient) continue;
            return false;
        }
        return this.bottleSlot.test(container.m_8020_(container.m_6643_() - 1));
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public Ingredient getBottleSlot() {
        return this.bottleSlot;
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<SmallCauldronRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public SmallCauldronRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)ingredients.size(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            Ingredient bottleSlot = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"bottle_slot"));
            int brewTime = GsonHelper.m_13824_((JsonObject)json, (String)"brew_time", (int)175);
            float experience = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            return new SmallCauldronRecipe(id, output, (NonNullList<Ingredient>)inputs, bottleSlot, brewTime, experience);
        }

        public SmallCauldronRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.m_122780_((int)buf.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack output = buf.m_130267_();
            Ingredient bottleSlot = Ingredient.m_43940_((FriendlyByteBuf)buf);
            int brewTime = buf.readInt();
            float experience = buf.readFloat();
            return new SmallCauldronRecipe(id, output, (NonNullList<Ingredient>)inputs, bottleSlot, brewTime, experience);
        }

        public void toNetwork(FriendlyByteBuf buf, SmallCauldronRecipe recipe) {
            buf.writeInt(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_(null));
            recipe.bottleSlot.m_43923_(buf);
            buf.writeInt(recipe.brewTime);
            buf.writeFloat(recipe.experience);
        }
    }

    public static class Type
    implements RecipeType<SmallCauldronRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "small_cauldron";
    }
}

