/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.util;

import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public final class SunlightCheck {
    private final Level level;
    private BlockPos pos;
    private final boolean needsRainCheck;
    private final float peakMultiplier;
    private boolean canSeeSun;

    public SunlightCheck(Level level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
        Biome biome = (Biome)this.level.m_204166_(this.pos).m_203334_();
        this.needsRainCheck = biome.m_264600_(this.pos) != Biome.Precipitation.NONE;
        float tempEff = 0.3f * (0.8f - biome.m_47554_());
        float humidity = SunlightCheck.resolveDownfall(biome);
        float humidityEff = this.needsRainCheck ? -0.3f * humidity : 0.0f;
        this.peakMultiplier = 1.0f + tempEff + humidityEff;
    }

    public void moveTo(BlockPos newPos) {
        this.pos = newPos;
        this.recheckCanSeeSun();
    }

    public void recheckCanSeeSun() {
        this.canSeeSun = SunlightCheck.canSeeSun(this.level, this.pos);
    }

    public boolean canSeeSunNow() {
        return this.canSeeSun;
    }

    public float getPeakMultiplier() {
        return this.peakMultiplier;
    }

    public float getGenerationMultiplier() {
        if (!this.canSeeSun) {
            return 0.0f;
        }
        if (this.needsRainCheck && (this.level.m_46471_() || this.level.m_46470_())) {
            return this.peakMultiplier * 0.2f;
        }
        return this.peakMultiplier;
    }

    public static float getSunBrightness(Level level, float partialTicks) {
        float t = level.m_46942_(partialTicks);
        float curve = 1.0f - (Mth.m_14089_((float)(t * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        curve = Mth.m_14036_((float)curve, (float)0.0f, (float)1.0f);
        curve = 1.0f - curve;
        curve = (float)((double)curve * (1.0 - (double)(level.m_46722_(partialTicks) * 5.0f) / 16.0));
        curve = (float)((double)curve * (1.0 - (double)(level.m_46661_(partialTicks) * 5.0f) / 16.0));
        return curve * 0.8f + 0.2f;
    }

    public static boolean canSeeSun(Level level, BlockPos pos) {
        if (level == null) {
            return false;
        }
        if (!level.m_6042_().f_223549_()) {
            return false;
        }
        if (level.m_7445_() >= 4) {
            return false;
        }
        return level.m_45527_(pos);
    }

    private static float resolveDownfall(Biome biome) {
        try {
            Method m = Biome.class.getMethod("getDownfall", new Class[0]);
            return ((Float)m.invoke((Object)biome, new Object[0])).floatValue();
        }
        catch (NoSuchMethodException ignored) {
            try {
                Method m = Biome.class.getMethod("downfall", new Class[0]);
                return ((Float)m.invoke((Object)biome, new Object[0])).floatValue();
            }
            catch (Exception e2) {
                return 0.0f;
            }
        }
        catch (Exception e) {
            return 0.0f;
        }
    }
}

