/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.util;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TeleportUtil {
    public static boolean canReturn(Level world, Player player, boolean allowInterdimensional) {
        if (world.m_5776_()) {
            return false;
        }
        ResourceKey spawnDim = ((ServerPlayer)player).m_8963_();
        return !allowInterdimensional && world.m_46472_() != spawnDim;
    }

    public static void teleportPlayerToSpawn(Level currentWorld, Player player, boolean allowInterdimensional) {
        BlockPos spawnPoint;
        if (currentWorld.m_5776_() || TeleportUtil.canReturn(currentWorld, player, allowInterdimensional)) {
            return;
        }
        ServerLevel targetWorld = TeleportUtil.getTargetWorld(currentWorld, player);
        player.m_8127_();
        if (player.m_5803_()) {
            player.m_5796_();
        }
        if (targetWorld != null && (spawnPoint = TeleportUtil.getSpawnPointPosition(player, targetWorld)) != null) {
            Optional<Vec3> pos = TeleportUtil.findRespawnPosition(targetWorld, spawnPoint, player);
            pos.ifPresent(vec -> TeleportUtil.doReturn(player, currentWorld, targetWorld, vec.f_82479_, vec.f_82480_, vec.f_82481_));
        }
    }

    private static ServerLevel getTargetWorld(Level currentWorld, Player player) {
        ResourceKey spawnDim = ((ServerPlayer)player).m_8963_();
        return currentWorld.m_46472_() == spawnDim ? (ServerLevel)currentWorld : Objects.requireNonNull(currentWorld.m_7654_()).m_129880_(spawnDim);
    }

    private static BlockPos getSpawnPointPosition(Player player, ServerLevel world) {
        return player instanceof ServerPlayer ? ((ServerPlayer)player).m_8961_() : null;
    }

    private static Optional<Vec3> findRespawnPosition(ServerLevel world, BlockPos spawnPoint, Player player) {
        return Player.m_36130_((ServerLevel)world, (BlockPos)spawnPoint, (float)((ServerPlayer)player).m_8962_(), (boolean)false, (boolean)true).map(pos -> new Vec3(pos.m_82507_(Direction.Axis.X) + 0.5, pos.m_82507_(Direction.Axis.Y), pos.m_82507_(Direction.Axis.Z) + 0.5));
    }

    private static void doReturn(Player player, Level origin, ServerLevel target, double x, double y, double z) {
        TeleportUtil.playTeleportSound(player, target, x, y, z);
        if (origin != target) {
            ((ServerPlayer)player).m_8999_(target, x, y, z, player.m_146908_(), player.m_146909_());
        } else {
            player.m_6021_(x, y, z);
        }
        if (player.f_19789_ > 0.0f) {
            player.f_19789_ = 0.0f;
        }
        TeleportUtil.playTeleportSound(player, target, x, y, z);
    }

    private static void playTeleportSound(Player player, ServerLevel world, double x, double y, double z) {
        world.m_6263_(null, x, y, z, SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

