/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import java.util.function.Supplier;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.custom.HerbBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CelestialBloomBlock
extends HerbBlock {
    private static final double MIN_X = 5.0;
    private static final double MAX_X = 11.0;
    private static final double MIN_Z = 5.0;
    private static final double MAX_Z = 11.0;
    private static final double HEIGHT = 10.0;

    public CelestialBloomBlock(Supplier<MobEffect> effectSupplier, int pEffectDuration, BlockBehaviour.Properties pProperties) {
        super(effectSupplier, pEffectDuration, pProperties);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if (level.m_5776_() && ((Boolean)Configuration.CELESTIAL_BLOOM_EMITS_PARTICLES.get()).booleanValue() && random.m_188501_() < 0.2f) {
            double centerX = (double)pos.m_123341_() + 0.5;
            double centerZ = (double)pos.m_123343_() + 0.5;
            double x = centerX + (random.m_188500_() - 0.5) * 6.0 / 16.0;
            double y = (double)pos.m_123342_() + random.m_188500_() * 10.0 / 16.0;
            double z = centerZ + (random.m_188500_() - 0.5) * 6.0 / 16.0;
            if (random.m_188499_()) {
                x = centerX + (random.m_188499_() ? 11.5 : 4.5) / 16.0;
            } else {
                z = centerZ + (random.m_188499_() ? 11.5 : 4.5) / 16.0;
            }
            double motionX = (random.m_188500_() - 0.5) * 0.02;
            double motionY = random.m_188500_() * 0.02;
            double motionZ = (random.m_188500_() - 0.5) * 0.02;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, motionX, motionY, motionZ);
        }
    }
}

