/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.custom.censer.CenserEffectHandler;
import net.astralya.hexalia.block.custom.censer.HerbCombination;
import net.astralya.hexalia.block.entity.custom.CenserBlockEntity;
import net.astralya.hexalia.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CenserBlock
extends BaseEntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public CenserBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Vec3 vec3 = pState.m_60824_(pLevel, pPos);
        return SHAPE.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_())) {
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof CenserBlockEntity) {
            CenserBlockEntity censer = (CenserBlockEntity)blockEntity;
            censer.tick((Level)pLevel, pPos, pState);
        }
        pLevel.m_186460_(pPos, (Block)this, 1);
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        if (level instanceof Level) {
            BlockEntity blockEntity;
            Level world = (Level)level;
            if (oldState.m_60734_() == newState.m_60734_() && (blockEntity = world.m_7702_(pos)) instanceof CenserBlockEntity) {
                CenserBlockEntity censer = (CenserBlockEntity)blockEntity;
                boolean wasLit = (Boolean)oldState.m_61143_((Property)LIT);
                boolean isLit = (Boolean)newState.m_61143_((Property)LIT);
                if (wasLit && !isLit) {
                    censer.clearItems();
                    world.m_7260_(pos, oldState, newState, 3);
                }
            }
        }
        super.onBlockStateChange(level, pos, oldState, newState);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof CenserBlockEntity)) {
            return InteractionResult.PASS;
        }
        CenserBlockEntity censer = (CenserBlockEntity)blockEntity;
        if (heldItem.m_41720_() instanceof FlintAndSteelItem && !((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            ItemStack herb1 = censer.getItem(0);
            ItemStack herb2 = censer.getItem(1);
            if (herb1.m_41619_() || herb2.m_41619_()) {
                if (pLevel.m_5776_()) {
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"message.hexalia.censer_not_full"), true);
                }
                return InteractionResult.FAIL;
            }
            HerbCombination combo = new HerbCombination(herb1.m_41720_(), herb2.m_41720_());
            if (!CenserEffectHandler.isValidCombination(herb1.m_41720_(), herb2.m_41720_())) {
                if (pLevel.m_5776_()) {
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"message.hexalia.invalid_herb_combination"), true);
                }
                return InteractionResult.FAIL;
            }
            if (!pLevel.m_5776_()) {
                this.sendEffectActivationMessage(pLevel, pPos, combo, pPlayer);
                censer.setActiveCombination(combo);
                censer.clearItems();
                pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
                censer.setBurnTime((Integer)Configuration.CENSER_EFFECT_DURATION.get());
                CenserEffectHandler.startEffect(pLevel, pPos, combo);
            }
            heldItem.m_41622_(1, (LivingEntity)pPlayer, p -> p.m_21190_(pHand));
            pLevel.m_5594_(null, pPos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, pLevel.f_46441_.m_188501_() * 0.4f + 0.8f);
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41720_() instanceof ShovelItem && ((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            if (!pLevel.m_5776_()) {
                pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
                censer.setBurnTime(0);
            }
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            if (heldItem.m_41619_()) {
                for (int i = 0; i < censer.getItems().size(); ++i) {
                    ItemStack stackInSlot = censer.getItem(i);
                    if (stackInSlot.m_41619_()) continue;
                    ItemStack removedStack = censer.removeStack(i);
                    if (!pPlayer.m_150109_().m_36054_(removedStack)) {
                        pPlayer.m_36176_(removedStack, false);
                    }
                    pLevel.m_5594_(null, pPos, SoundEvents.f_12016_, SoundSource.BLOCKS, 0.5f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            } else if (heldItem.m_204117_(ModTags.Items.HERBS)) {
                for (int i = 0; i < censer.getItems().size(); ++i) {
                    if (!censer.getItem(i).m_41619_()) continue;
                    ItemStack stackToInsert = heldItem.m_41777_();
                    stackToInsert.m_41764_(1);
                    censer.setItem(i, stackToInsert);
                    if (!pPlayer.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    pLevel.m_5594_(null, pPos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.5f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (pLevel.m_5776_()) {
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"message.hexalia.invalid_item"), true);
                }
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.PASS;
    }

    private void sendEffectActivationMessage(Level level, BlockPos pos, HerbCombination combo, Player activatingPlayer) {
        String messageKey = CenserEffectHandler.getMessageKeyForCombination(combo);
        int radius = (Integer)Configuration.CENSER_EFFECT_RADIUS.get();
        AABB area = new AABB(pos).m_82400_((double)radius);
        for (Player player : level.m_45976_(Player.class, area)) {
            if (player.m_20148_().equals(activatingPlayer.m_20148_()) || !(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_5661_((Component)Component.m_237115_((String)messageKey), true);
        }
        if (!level.m_5776_() && activatingPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)activatingPlayer;
            serverPlayer.m_5661_((Component)Component.m_237115_((String)messageKey), true);
        }
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            if (pRandom.m_188503_(10) == 0) {
                pLevel.m_7785_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + pRandom.m_188501_(), pRandom.m_188501_() * 0.7f + 0.6f, false);
            }
            pLevel.m_6485_((ParticleOptions)ParticleTypes.f_123777_, true, (double)pPos.m_123341_() + 0.5 + pRandom.m_188500_() / 3.0 * (double)(pRandom.m_188499_() ? 1 : -1), (double)pPos.m_123342_() + pRandom.m_188500_() + pRandom.m_188500_(), (double)pPos.m_123343_() + 0.5 + pRandom.m_188500_() / 3.0 * (double)(pRandom.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pPos.m_123341_() + 0.5 + pRandom.m_188500_() / 4.0 * (double)(pRandom.m_188499_() ? 1 : -1), (double)pPos.m_123342_() + 0.4, (double)pPos.m_123343_() + 0.5 + pRandom.m_188500_() / 4.0 * (double)(pRandom.m_188499_() ? 1 : -1), 0.0, 0.005, 0.0);
            if (pRandom.m_188503_(25) == 0) {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.3, (double)pPos.m_123343_() + 0.5, (double)(pRandom.m_188501_() / 8.0f), 0.0, (double)(pRandom.m_188501_() / 8.0f));
            }
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof CenserBlockEntity) {
                CenserBlockEntity censer = (CenserBlockEntity)blockEntity;
                if (world instanceof ServerLevel) {
                    Containers.m_19010_((Level)world, (BlockPos)pos, censer.getItems());
                }
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, LIT});
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CenserBlockEntity(pos, state);
    }
}

