/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import net.astralya.hexalia.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChillberryBushBlock
extends BushBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)3);

    public ChillberryBushBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)ModItems.CHILLBERRIES.get());
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof LivingEntity && pEntity.m_6095_() != EntityType.f_20452_ && pEntity.m_6095_() != EntityType.f_20550_ && (Integer)pState.m_61143_((Property)AGE) >= 2) {
            pEntity.m_7601_(pState, new Vec3((double)0.8f, 0.75, (double)0.8f));
            pEntity.m_146924_(true);
            if (pLevel.f_46443_) {
                boolean flag;
                RandomSource randomsource = pLevel.m_213780_();
                boolean bl = flag = pEntity.f_19790_ != pEntity.m_20185_() || pEntity.f_19792_ != pEntity.m_20189_();
                if (flag && randomsource.m_188499_()) {
                    pLevel.m_7106_((ParticleOptions)ParticleTypes.f_175821_, pEntity.m_20185_(), (double)(pPos.m_123342_() + 1), pEntity.m_20189_(), (double)(Mth.m_216283_((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.m_216283_((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f));
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        int age = (Integer)pState.m_61143_((Property)AGE);
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (age == 3) {
            int berryCount = 1 + pLevel.f_46441_.m_188503_(2);
            ChillberryBushBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)ModItems.CHILLBERRIES.get(), berryCount + 1));
            pLevel.m_5594_(null, pPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)));
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pPlayer, (BlockState)((BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)))));
            return InteractionResult.SUCCESS;
        }
        if (age > 1) {
            int berryCount = 1 + pLevel.f_46441_.m_188503_(2);
            ChillberryBushBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)ModItems.CHILLBERRIES.get(), berryCount));
            pLevel.m_5594_(null, pPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)));
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pPlayer, (BlockState)((BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)))));
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return (Integer)pState.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        int age = Math.min(3, (Integer)pState.m_61143_((Property)AGE) + 1);
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((Integer)pState.m_61143_((Property)AGE) < 3 && pRandom.m_188503_(5) == 0 && pLevel.m_45524_(pPos.m_7494_(), 0) >= 9) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)pState.m_61143_((Property)AGE) + 1)));
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223722_((BlockState)((BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)pState.m_61143_((Property)AGE) + 1)))));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }
}

