/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.List;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class NautiliteBlockEntity
extends BlockEntity {
    private int activeTicks = 0;
    private long activationTime = -1L;

    public NautiliteBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntityTypes.NAUTILITE_BE.get(), pPos, pBlockState);
    }

    public void activate() {
        this.activeTicks = (Integer)Configuration.NAUTILITE_DURATION.get();
        if (this.f_58857_ != null) {
            this.activationTime = this.f_58857_.m_46467_();
        }
        this.m_6596_();
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NautiliteBlockEntity blockEntity) {
        if (blockEntity.activationTime != -1L && level != null) {
            long currentTime = level.m_46467_();
            long elapsed = currentTime - blockEntity.activationTime;
            int expectedTicks = (Integer)Configuration.NAUTILITE_DURATION.get() - (int)elapsed;
            if (Math.abs(blockEntity.activeTicks - expectedTicks) > 5) {
                blockEntity.activeTicks = Math.max(0, expectedTicks);
            }
        }
        if (blockEntity.isActive()) {
            --blockEntity.activeTicks;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                int radius = (Integer)Configuration.NAUTILITE_EFFECT_RADIUS.get();
                AABB area = new AABB(pos).m_82400_((double)radius);
                List players = serverLevel.m_45976_(Player.class, area);
                List mobs = serverLevel.m_45976_(LivingEntity.class, area);
                for (Player player : players) {
                    if (player.m_20070_()) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19592_, 40, 0, true, false));
                    }
                    if (!player.m_21023_(MobEffects.f_19599_)) continue;
                    player.m_21195_(MobEffects.f_19599_);
                }
                for (LivingEntity mob : mobs) {
                    if (!(mob instanceof Drowned) && !(mob instanceof Guardian) || !mob.m_20070_() || !pos.m_123314_((Vec3i)mob.m_20183_(), (double)radius)) continue;
                    mob.m_6469_(level.m_269111_().m_269425_(), 2.0f);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), 10, 0.5, 0.5, 0.5, 0.1);
                }
                NautiliteBlockEntity.emitParticles(serverLevel, pos);
            }
            if (blockEntity.activeTicks <= 0) {
                level.m_5594_(null, pos, SoundEvents.f_11824_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46961_(pos, false);
            } else {
                blockEntity.m_6596_();
            }
        }
    }

    private static void emitParticles(ServerLevel level, BlockPos pos) {
        Vec3 center = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        RandomSource random = level.f_46441_;
        for (int i = 0; i < 5; ++i) {
            double x = center.f_82479_ + (random.m_188500_() - 0.5) * 2.0;
            double y = center.f_82480_ + (random.m_188500_() - 0.5) * 2.0;
            double z = center.f_82481_ + (random.m_188500_() - 0.5) * 2.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("ActiveTicks", this.activeTicks);
        tag.m_128356_("ActivationTime", this.activationTime);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.activeTicks = tag.m_128451_("ActiveTicks");
        this.activationTime = tag.m_128454_("ActivationTime");
        if (this.activationTime != -1L && this.f_58857_ != null && this.activeTicks > 0) {
            long currentTime = this.f_58857_.m_46467_();
            long elapsed = currentTime - this.activationTime;
            this.activeTicks = Math.max(0, (Integer)Configuration.NAUTILITE_DURATION.get() - (int)elapsed);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("ActiveTicks", this.activeTicks);
        tag.m_128356_("ActivationTime", this.activationTime);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

