/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.List;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.sound.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WindsongBlockEntity
extends BlockEntity {
    private int activeTicks = 0;
    private long activationTime = -1L;
    private int duration = 600;
    private int particleCooldown = 0;

    public WindsongBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntityTypes.WINDSONG_BE.get(), pPos, pBlockState);
    }

    public void activate() {
        this.activate((Integer)Configuration.WINDSONG_DURATION.get());
    }

    public void activate(int customDuration) {
        this.activeTicks = customDuration;
        this.duration = customDuration;
        if (this.f_58857_ != null) {
            this.activationTime = this.f_58857_.m_46467_();
        }
        this.m_6596_();
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public int getDuration() {
        return this.duration;
    }

    public float getProgress() {
        if (this.duration <= 0) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.duration - this.activeTicks) / (float)this.duration);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (this.isActive()) {
            --this.activeTicks;
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                int radius = (Integer)Configuration.WINDSONG_EFFECT_RADIUS.get();
                AABB area = new AABB(pPos).m_82400_((double)radius);
                List projectiles = serverLevel.m_6443_(Entity.class, area, entity -> entity instanceof Projectile);
                for (Entity projectile : projectiles) {
                    if (projectile.m_213877_()) continue;
                    this.discardProjectile(serverLevel, projectile);
                }
                this.emitParticles(serverLevel, pPos);
            }
            if (this.activeTicks <= 0) {
                pLevel.m_5594_(null, pPos, (SoundEvent)ModSoundEvents.WIND_BURST.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                pLevel.m_46961_(pPos, false);
            }
        }
    }

    private void discardProjectile(ServerLevel pLevel, Entity projectile) {
        pLevel.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), (SoundEvent)ModSoundEvents.WIND_DEFLECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        Vec3 pos = projectile.m_20182_();
        for (int i = 0; i < 5; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            double radius = Math.random() * 0.5;
            double x = pos.f_82479_ + radius * Math.cos(angle);
            double z = pos.f_82481_ + radius * Math.sin(angle);
            double y = pos.f_82480_ + Math.random() * 0.5;
            pLevel.m_8767_((ParticleOptions)ParticleTypes.f_123806_, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
        projectile.m_146870_();
    }

    private void emitParticles(ServerLevel level, BlockPos pos) {
        if (this.particleCooldown <= 0) {
            Vec3 center = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            float progress = this.getProgress();
            int particleCount = Math.max(1, (int)(3.0f * (1.0f - progress * 0.5f)));
            for (int i = 0; i < particleCount; ++i) {
                double angle = Math.random() * 2.0 * Math.PI;
                double radius = Math.random() * (double)((Integer)Configuration.WINDSONG_EFFECT_RADIUS.get()).intValue();
                double x = center.f_82479_ + radius * Math.cos(angle);
                double z = center.f_82481_ + radius * Math.sin(angle);
                double y = center.f_82480_ + Math.random() * 2.0;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
            }
            this.particleCooldown = 5;
        } else {
            --this.particleCooldown;
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("ActiveTicks", this.activeTicks);
        tag.m_128356_("ActivationTime", this.activationTime);
        tag.m_128405_("Duration", this.duration);
        tag.m_128405_("ParticleCooldown", this.particleCooldown);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.activeTicks = tag.m_128451_("ActiveTicks");
        this.activationTime = tag.m_128454_("ActivationTime");
        this.duration = tag.m_128441_("Duration") ? tag.m_128451_("Duration") : ((Integer)Configuration.WINDSONG_DURATION.get()).intValue();
        this.particleCooldown = tag.m_128451_("ParticleCooldown");
        if (this.activationTime != -1L && this.f_58857_ != null && this.activeTicks > 0) {
            long currentTime = this.f_58857_.m_46467_();
            long elapsed = currentTime - this.activationTime;
            this.activeTicks = Math.max(0, this.duration - (int)elapsed);
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("ActiveTicks", this.activeTicks);
        tag.m_128356_("ActivationTime", this.activationTime);
        tag.m_128405_("Duration", this.duration);
        tag.m_128405_("ParticleCooldown", this.particleCooldown);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return super.m_58483_();
    }
}

