/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.compat.jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.compat.jei.category.RitualBrazierRecipeCategory;
import net.astralya.hexalia.compat.jei.category.RitualTableRecipeCategory;
import net.astralya.hexalia.compat.jei.category.SmallCauldronRecipeCategory;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.recipe.RitualBrazierRecipe;
import net.astralya.hexalia.recipe.RitualTableRecipe;
import net.astralya.hexalia.recipe.SmallCauldronRecipe;
import net.astralya.hexalia.screen.SmallCauldronScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("hexalia", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SmallCauldronRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RitualTableRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RitualBrazierRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SMALL_CAULDRON.get()), new RecipeType[]{SmallCauldronRecipeCategory.SMALL_CAULDRON_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.RITUAL_TABLE.get()), new RecipeType[]{RitualTableRecipeCategory.RITUAL_TABLE_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.RITUAL_BRAZIER.get()), new RecipeType[]{RitualBrazierRecipeCategory.RITUAL_BRAZIER_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List smallCauldronRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)SmallCauldronRecipe.Type.INSTANCE);
        registration.addRecipes(SmallCauldronRecipeCategory.SMALL_CAULDRON_TYPE, smallCauldronRecipes);
        List transmutationRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RitualTableRecipe.Type.INSTANCE);
        registration.addRecipes(RitualTableRecipeCategory.RITUAL_TABLE_RECIPE_RECIPE_TYPE, transmutationRecipes);
        List ritualBrazierRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RitualBrazierRecipe.Type.INSTANCE);
        registration.addRecipes(RitualBrazierRecipeCategory.RITUAL_BRAZIER_TYPE, ritualBrazierRecipes);
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModBlocks.WILD_SUNFIRE_TOMATO.get()), new ItemStack((ItemLike)ModItems.SUNFIRE_TOMATO.get()), new ItemStack((ItemLike)ModItems.SUNFIRE_TOMATO_SEEDS.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.info.wild_sunfire_tomatoes")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModBlocks.WILD_MANDRAKE.get()), new ItemStack((ItemLike)ModItems.MANDRAKE.get()), new ItemStack((ItemLike)ModItems.MANDRAKE_SEEDS.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.info.wild_mandrakes")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModBlocks.CHILLBERRY_BUSH.get()), new ItemStack((ItemLike)ModItems.CHILLBERRIES.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.info.chillberry_bushes")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModItems.SALTSPROUT.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.info.saltsprout")});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(SmallCauldronScreen.class, 89, 25, 24, 17, new RecipeType[]{SmallCauldronRecipeCategory.SMALL_CAULDRON_TYPE});
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

