/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.compat.jei.category;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.recipe.RitualTableRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class RitualTableRecipeCategory
implements IRecipeCategory<RitualTableRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("hexalia", "ritual_table");
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexalia", "textures/gui/ritual_table_gui.png");
    public static final RecipeType<RitualTableRecipe> RITUAL_TABLE_RECIPE_RECIPE_TYPE = new RecipeType(UID, RitualTableRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable hexIcon;

    public RitualTableRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 118, 80);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.RITUAL_TABLE.get()));
        this.hexIcon = helper.createDrawable(TEXTURE, 0, 0, 16, 16);
    }

    public RecipeType<RitualTableRecipe> getRecipeType() {
        return RITUAL_TABLE_RECIPE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.hexalia.ritual_table");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RitualTableRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        if (!ingredients.isEmpty()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 28, 31).addIngredients((Ingredient)ingredients.get(0));
        }
        int[] xPositions = new int[]{28, 28, 52, 4};
        int[] yPositions = new int[]{7, 55, 31, 31};
        for (int i = 1; i < ingredients.size() && i <= 4; ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, xPositions[i - 1], yPositions[i - 1]).addIngredients((Ingredient)ingredients.get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 89, 31).addItemStack(recipe.m_8043_(null));
    }

    public void draw(RitualTableRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.hexIcon.draw(guiGraphics, 4, 55);
    }

    public List<Component> getTooltipStrings(RitualTableRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 4.0 && mouseX < 20.0 && mouseY >= 55.0 && mouseY < 71.0) {
            return List.of(Component.m_237115_((String)"tooltip.hexalia.hex_focus_gui"));
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }
}

