/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.compat.patchouli;

import net.astralya.hexalia.recipe.RitualTableRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class RitualTableProcessor
implements IComponentProcessor {
    private RitualTableRecipe recipe;

    private static Level ctx(Level level) {
        Level world;
        Object object = world = level != null ? level : Minecraft.m_91087_().f_91073_;
        if (world == null) {
            throw new IllegalStateException("No level available for RitualTableProcessor");
        }
        return world;
    }

    public void setup(Level level, IVariableProvider variables) {
        Level world = RitualTableProcessor.ctx(level);
        ResourceLocation recipeId = new ResourceLocation(variables.get("recipe").asString());
        this.recipe = world.m_7465_().m_44043_(recipeId).filter(r -> r.m_6671_().equals(RitualTableRecipe.Type.INSTANCE)).map(r -> (RitualTableRecipe)r).orElseThrow(() -> new IllegalArgumentException("Ritual Table recipe not found: " + recipeId));
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        if ("output".equals(key)) {
            return IVariable.from((Object)this.recipe.m_8043_(RitualTableProcessor.ctx(level).m_9598_()));
        }
        if ("header".equals(key)) {
            return IVariable.from((Object)this.recipe.m_8043_(RitualTableProcessor.ctx(level).m_9598_()).m_41786_());
        }
        if ("input_main".equals(key)) {
            if (!this.recipe.m_7527_().isEmpty()) {
                Ingredient main = (Ingredient)this.recipe.m_7527_().get(0);
                ItemStack[] stacks = main.m_43908_();
                return stacks.length > 0 ? IVariable.from((Object)stacks[0]) : null;
            }
            return null;
        }
        if (key.startsWith("input_brazier")) {
            try {
                int idx;
                int ingIndex = idx = Integer.parseInt(key.substring("input_brazier".length()));
                if (ingIndex >= 1 && ingIndex < this.recipe.m_7527_().size()) {
                    Ingredient ing = (Ingredient)this.recipe.m_7527_().get(ingIndex);
                    ItemStack[] stacks = ing.m_43908_();
                    return stacks.length > 0 ? IVariable.from((Object)stacks[0]) : null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        }
        return null;
    }
}

