/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.astralya.hexalia.recipe.RitualTableRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class RitualTableRecipeBuilder
implements RecipeBuilder {
    private final NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    private final ItemStack outputStack;
    private final Item resultItem;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private final Map<String, CriterionTriggerInstance> criteria = new LinkedHashMap<String, CriterionTriggerInstance>();

    public RitualTableRecipeBuilder(ItemStack output) {
        this.outputStack = output.m_41777_();
        this.resultItem = this.outputStack.m_41720_();
    }

    public static RitualTableRecipeBuilder ritualTable(ItemStack output) {
        return new RitualTableRecipeBuilder(output);
    }

    public RitualTableRecipeBuilder tableInput(Ingredient ingredient) {
        if (!this.ingredients.isEmpty()) {
            throw new IllegalStateException("Table input must be added first.");
        }
        this.ingredients.add((Object)ingredient);
        return this;
    }

    public RitualTableRecipeBuilder tableInput(Item item) {
        return this.tableInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public RitualTableRecipeBuilder tableInput(ItemStack stack) {
        return this.tableInput(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
    }

    public RitualTableRecipeBuilder brazier(Ingredient ingredient) {
        this.ingredients.add((Object)ingredient);
        return this;
    }

    public RitualTableRecipeBuilder brazier(Item item) {
        return this.brazier(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public RitualTableRecipeBuilder brazier(ItemStack stack) {
        return this.brazier(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
    }

    public RitualTableRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterion) {
        this.criteria.put(name, criterion);
        this.advancement.m_138386_(name, criterion);
        return this;
    }

    public RitualTableRecipeBuilder unlockedByItem(String name, Item item) {
        return this.unlockedBy(name, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{item}));
    }

    public RecipeBuilder m_126145_(@Nullable String group) {
        return this;
    }

    public Item m_142372_() {
        return this.resultItem;
    }

    public void m_126140_(Consumer<FinishedRecipe> out, ResourceLocation id) {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("Ritual Table recipe requires at least 1 ingredient (the table input).");
        }
        if (this.ingredients.size() > 5) {
            throw new IllegalStateException("Too many ingredients for Ritual Table (max 5).");
        }
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        ResourceLocation advId = id.m_246208_("recipes/ritual_table/");
        out.accept(new Result(id, this.ingredients, this.outputStack, this.advancement, advId));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final NonNullList<Ingredient> ingredients;
        private final ItemStack output;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, NonNullList<Ingredient> ingredients, ItemStack output, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.ingredients = ingredients;
            this.output = output.m_41777_();
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("type", "hexalia:ritual_table");
            JsonArray arr = new JsonArray();
            for (Ingredient ing : this.ingredients) {
                arr.add(ing.m_43942_());
            }
            json.add("ingredients", (JsonElement)arr);
            JsonObject out = new JsonObject();
            out.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.output.m_41720_()).toString());
            if (this.output.m_41613_() > 1) {
                out.addProperty("count", (Number)this.output.m_41613_());
            }
            json.add("output", (JsonElement)out);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return RitualTableRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

