/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.item.custom;

import java.util.Map;
import java.util.Set;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AthameItem
extends Item {
    private static final Set<Block> STRIPPABLE_LOGS = Set.of(Blocks.f_50004_, (Block)ModBlocks.COTTONWOOD_LOG.get());
    private static final Map<Block, Block> STRIPPED_BLOCKS = Map.of(Blocks.f_50004_, Blocks.f_50009_, (Block)ModBlocks.COTTONWOOD_LOG.get(), (Block)ModBlocks.STRIPPED_COTTONWOOD_LOG.get());

    public AthameItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        Player player = pContext.m_43723_();
        BlockPos blockPos = pContext.m_8083_();
        BlockState state = level.m_8055_(blockPos);
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_() && state.m_204336_(BlockTags.f_13090_)) {
            this.transformPlanksIntoBrazier(level, blockPos, player, pContext);
            return InteractionResult.SUCCESS;
        }
        if (STRIPPABLE_LOGS.contains(state.m_60734_())) {
            this.stripLog(level, blockPos, state, player, pContext);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(pContext);
    }

    private void transformPlanksIntoBrazier(Level level, BlockPos blockPos, Player player, UseOnContext pContext) {
        if (!level.f_46443_) {
            level.m_5594_(null, blockPos, SoundEvents.f_12630_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            Block.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)ModBlocks.RITUAL_BRAZIER.get()));
            this.handleItemDamage(player, pContext.m_43722_(), pContext);
        }
    }

    private void stripLog(Level level, BlockPos blockPos, BlockState state, Player player, UseOnContext pContext) {
        if (!level.f_46443_) {
            level.m_5594_(null, blockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            Block strippedBlock = this.getStrippedBlock(state.m_60734_());
            level.m_7731_(blockPos, (BlockState)strippedBlock.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))), 3);
            Block.m_49840_((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)ModItems.TREE_RESIN.get()));
            this.handleItemDamage(player, pContext.m_43722_(), pContext);
        }
    }

    private Block getStrippedBlock(Block originalBlock) {
        return STRIPPED_BLOCKS.getOrDefault(originalBlock, originalBlock);
    }

    private void handleItemDamage(Player player, ItemStack stack, UseOnContext pContext) {
        if (!player.m_7500_() && stack.m_41763_()) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(pContext.m_43724_()));
            if (stack.m_41619_()) {
                player.m_21008_(pContext.m_43724_(), ItemStack.f_41583_);
            }
        }
    }
}

