/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.item.custom;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CustomModelSpawnEggItem
extends Item {
    private final Supplier<? extends EntityType<? extends Mob>> defaultType;

    public CustomModelSpawnEggItem(Supplier<? extends EntityType<? extends Mob>> defaultType, Item.Properties properties) {
        super(properties);
        this.defaultType = defaultType;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel server = (ServerLevel)level;
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        BlockState state = level.m_8055_(pos);
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerBE = (SpawnerBlockEntity)be;
            BaseSpawner spawner = spawnerBE.m_59801_();
            EntityType<?> type = this.getType(stack);
            spawner.m_253197_(type, level, level.m_213780_(), pos);
            spawnerBE.m_6596_();
            level.m_7260_(pos, state, state, 3);
            level.m_142346_((Entity)context.m_43723_(), GameEvent.f_157792_, pos);
            if (context.m_43723_() == null || !context.m_43723_().m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        BlockPos spawnPos = state.m_60812_((BlockGetter)level, pos).m_83281_() ? pos : pos.m_121945_(face);
        EntityType<?> type = this.getType(stack);
        if (type.m_20592_(server, stack, context.m_43723_(), spawnPos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(pos, spawnPos) && face == Direction.UP) != null) {
            if (context.m_43723_() == null || !context.m_43723_().m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            level.m_142346_((Entity)context.m_43723_(), GameEvent.f_157810_, pos);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hit = CustomModelSpawnEggItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!(level instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        ServerLevel server = (ServerLevel)level;
        BlockPos pos = hit.m_82425_();
        if (!(level.m_8055_(pos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (level.m_7966_(player, pos) && player.m_36204_(pos, hit.m_82434_(), stack)) {
            EntityType<?> type = this.getType(stack);
            Entity e = type.m_20592_(server, stack, player, pos, MobSpawnType.SPAWN_EGG, false, false);
            if (e == null) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            level.m_220400_((Entity)player, GameEvent.f_157810_, e.m_20182_());
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public boolean spawnsEntity(ItemStack stack, EntityType<?> entityType) {
        return Objects.equals(this.getType(stack), entityType);
    }

    public EntityType<?> getType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            Optional t;
            ResourceLocation rl;
            Optional t2;
            ResourceLocation rl2;
            CompoundTag ent;
            if (tag.m_128425_("EntityTag", 10) && (ent = tag.m_128469_("EntityTag")).m_128425_("id", 8) && (rl2 = ResourceLocation.m_135820_((String)ent.m_128461_("id"))) != null && (t2 = EntityType.m_20632_((String)rl2.toString())).isPresent()) {
                return (EntityType)t2.get();
            }
            if (tag.m_128425_("EntityType", 8) && (rl = ResourceLocation.m_135820_((String)tag.m_128461_("EntityType"))) != null && (t = EntityType.m_20632_((String)rl.toString())).isPresent()) {
                return (EntityType)t.get();
            }
        }
        return this.getDefaultType();
    }

    public Optional<Mob> spawnOffspringFromSpawnEgg(Player player, Mob parent, EntityType<? extends Mob> entityType, ServerLevel serverLevel, Vec3 pos, ItemStack stack) {
        Mob baby;
        if (!this.spawnsEntity(stack, entityType)) {
            return Optional.empty();
        }
        if (parent instanceof AgeableMob) {
            AgeableMob ageable = (AgeableMob)parent;
            v0 = ageable.m_142606_(serverLevel, ageable);
        } else {
            v0 = baby = (Mob)entityType.m_20615_((Level)serverLevel);
        }
        if (baby == null) {
            return Optional.empty();
        }
        baby.m_6863_(true);
        if (!baby.m_6162_()) {
            return Optional.empty();
        }
        baby.m_7678_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0.0f, 0.0f);
        serverLevel.m_47205_((Entity)baby);
        if (stack.m_41788_()) {
            baby.m_6593_(stack.m_41786_());
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return Optional.of(baby);
    }

    public FeatureFlagSet m_245183_() {
        return this.getDefaultType().m_245183_();
    }

    protected EntityType<?> getDefaultType() {
        return this.defaultType.get();
    }
}

