/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.worldgen;

import java.util.List;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.worldgen.ModConfiguredFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> SPIRIT_BLOOM_PLACED = ModPlacedFeatures.registerKey("spirit_bloom_placed");
    public static final ResourceKey<PlacedFeature> DREAMSHROOM_PLACED = ModPlacedFeatures.registerKey("dreamshroom_placed");
    public static final ResourceKey<PlacedFeature> SIREN_KELP_PLACED = ModPlacedFeatures.registerKey("siren_kelp_placed");
    public static final ResourceKey<PlacedFeature> CHILLBERRY_PLACED = ModPlacedFeatures.registerKey("chillberry_placed");
    public static final ResourceKey<PlacedFeature> WILD_SUNFIRE_TOMATO_PLACED = ModPlacedFeatures.registerKey("wild_sunfire_tomato_placed");
    public static final ResourceKey<PlacedFeature> WILD_MANDRAKE_PLACED = ModPlacedFeatures.registerKey("wild_mandrake_placed");
    public static final ResourceKey<PlacedFeature> GHOST_FERN_PLACED = ModPlacedFeatures.registerKey("ghost_fern_placed");
    public static final ResourceKey<PlacedFeature> CELESTIAL_BLOOM_PLACED = ModPlacedFeatures.registerKey("celestial_bloom_placed");
    public static final ResourceKey<PlacedFeature> BEGONIA_PLACED = ModPlacedFeatures.registerKey("begonia_placed");
    public static final ResourceKey<PlacedFeature> LAVENDER_PLACED = ModPlacedFeatures.registerKey("lavender_placed");
    public static final ResourceKey<PlacedFeature> DAHLIA_PLACED = ModPlacedFeatures.registerKey("dahlia_placed");
    public static final ResourceKey<PlacedFeature> LOTUS_FLOWER_PLACED = ModPlacedFeatures.registerKey("lotus_flower_placed");
    public static final ResourceKey<PlacedFeature> PALE_MUSHROOM_PLACED = ModPlacedFeatures.registerKey("pale_mushroom_placed");
    public static final ResourceKey<PlacedFeature> WITCHWEED_PLACED = ModPlacedFeatures.registerKey("witchweed_placed");
    public static final ResourceKey<PlacedFeature> NIGHTSHADE_BUSH_PLACED = ModPlacedFeatures.registerKey("nightshade_bush_placed");
    public static final ResourceKey<PlacedFeature> COTTONWOOD_PLACED = ModPlacedFeatures.registerKey("cottonwood_placed");
    public static final ResourceKey<PlacedFeature> WILLOW_PLACED = ModPlacedFeatures.registerKey("willow_placed");
    public static final ResourceKey<PlacedFeature> DARK_OAK_COCOON_PLACED = ModPlacedFeatures.registerKey("dark_oak_cocoon_placed");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        HolderGetter configured = context.m_255420_(Registries.f_256911_);
        ModPlacedFeatures.register(context, SPIRIT_BLOOM_PLACED, configured.m_255043_(ModConfiguredFeatures.SPIRIT_BLOOM), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, DREAMSHROOM_PLACED, configured.m_255043_(ModConfiguredFeatures.DREAMSHROOM), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, SIREN_KELP_PLACED, configured.m_255043_(ModConfiguredFeatures.SIREN_KELP), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, CHILLBERRY_PLACED, configured.m_255043_(ModConfiguredFeatures.CHILLBERRY), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, WILD_SUNFIRE_TOMATO_PLACED, configured.m_255043_(ModConfiguredFeatures.WILD_SUNFIRE_TOMATO), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, WILD_MANDRAKE_PLACED, configured.m_255043_(ModConfiguredFeatures.WILD_MANDRAKE), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, GHOST_FERN_PLACED, configured.m_255043_(ModConfiguredFeatures.GHOST_FERN), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, CELESTIAL_BLOOM_PLACED, configured.m_255043_(ModConfiguredFeatures.CELESTIAL_BLOOM), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, BEGONIA_PLACED, configured.m_255043_(ModConfiguredFeatures.BEGONIA), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, LAVENDER_PLACED, configured.m_255043_(ModConfiguredFeatures.LAVENDER), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, DAHLIA_PLACED, configured.m_255043_(ModConfiguredFeatures.DAHLIA), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, PALE_MUSHROOM_PLACED, configured.m_255043_(ModConfiguredFeatures.PALE_MUSHROOM), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, WITCHWEED_PLACED, configured.m_255043_(ModConfiguredFeatures.WITCHWEED), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, NIGHTSHADE_BUSH_PLACED, configured.m_255043_(ModConfiguredFeatures.NIGHTSHADE_BUSH), ModPlacedFeatures.rarityPatch(10));
        ModPlacedFeatures.register(context, LOTUS_FLOWER_PLACED, configured.m_255043_(ModConfiguredFeatures.LOTUS_FLOWER), ModPlacedFeatures.waterSurfacePatch(1));
        ModPlacedFeatures.register(context, COTTONWOOD_PLACED, configured.m_255043_(ModConfiguredFeatures.COTTONWOOD), ModPlacedFeatures.rareTreePlacement((Block)ModBlocks.COTTONWOOD_SAPLING.get(), 25));
        ModPlacedFeatures.register(context, WILLOW_PLACED, configured.m_255043_(ModConfiguredFeatures.WILLOW), ModPlacedFeatures.rareTreePlacement((Block)ModBlocks.WILLOW_SAPLING.get(), 25));
        ModPlacedFeatures.register(context, DARK_OAK_COCOON_PLACED, configured.m_255043_(ModConfiguredFeatures.DARK_OAK_COCOON), ModPlacedFeatures.rareTreePlacement(Blocks.f_50751_, 25));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("hexalia", name));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    private static List<PlacementModifier> rarityPatch(int rarity) {
        return List.of(RarityFilter.m_191900_((int)rarity), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> waterSurfacePatch(int count) {
        return List.of(CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> rareTreePlacement(Block sapling, int rarity) {
        return List.of(RarityFilter.m_191900_((int)rarity), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, BiomeFilter.m_191561_(), BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)sapling.m_49966_(), (Vec3i)BlockPos.f_121853_)));
    }
}

