/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.astralya.hexalia.block.custom.RitualBrazierBlock;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.RitualBrazierBlockEntity;
import net.astralya.hexalia.block.entity.custom.RitualTableBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.RitualTableRecipe;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class RitualTableBlock
extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;
    private static final class_265 SHAPE = class_259.method_17786((class_265)class_259.method_1081((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.125, (double)0.8125), (class_265[])new class_265[]{class_259.method_1081((double)0.25, (double)0.125, (double)0.25, (double)0.75, (double)0.625, (double)0.75), class_259.method_1081((double)0.1875, (double)0.625, (double)0.1875, (double)0.8125, (double)0.6875, (double)0.8125), class_259.method_1081((double)0.125, (double)0.6875, (double)0.125, (double)0.875, (double)0.8125, (double)0.875)});

    public RitualTableBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new RitualTableBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : RitualTableBlock.method_31618(type, ModBlockEntityTypes.RITUAL_TABLE, RitualTableBlockEntity::tick);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        class_2586 be;
        if (state.method_26204() != newState.method_26204() && (be = world.method_8321(pos)) instanceof RitualTableBlockEntity) {
            RitualTableBlockEntity table = (RitualTableBlockEntity)be;
            class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)table);
            world.method_8455(pos, (class_2248)this);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof RitualTableBlockEntity)) {
            return class_1269.field_5811;
        }
        RitualTableBlockEntity tableBE = (RitualTableBlockEntity)be;
        if (stack.method_31574(ModItems.HEX_FOCUS) && this.tryStartRitual(world, pos, player, tableBE, stack)) {
            return class_1269.field_5812;
        }
        if (tableBE.method_5442() && !stack.method_7960() && !stack.method_31574(ModItems.HEX_FOCUS)) {
            this.addItemToBlock(stack, world, pos, player, tableBE);
            return class_1269.field_5812;
        }
        if (stack.method_7960() && !tableBE.method_5438(0).method_7960()) {
            this.removeItemFromBlock(world, pos, player, tableBE);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private boolean tryStartRitual(class_1937 world, class_2338 pos, class_1657 player, RitualTableBlockEntity tableBE, class_1799 held) {
        class_1799 tableItem = tableBE.method_5438(0);
        class_2338[] offsets = new class_2338[]{pos.method_10076(2), pos.method_10077(2), pos.method_10089(2), pos.method_10088(2)};
        ArrayList<RitualBrazierBlockEntity> filledBraziers = new ArrayList<RitualBrazierBlockEntity>();
        for (class_2338 bp : offsets) {
            RitualBrazierBlockEntity brazier;
            class_2586 be = world.method_8321(bp);
            if (!(be instanceof RitualBrazierBlockEntity) || (brazier = (RitualBrazierBlockEntity)be).method_5442()) continue;
            filledBraziers.add(brazier);
        }
        MatchResult match = this.findMatchingRecipe(world, tableItem, filledBraziers);
        if (match == null) {
            this.failWithMessage(world, pos, player, "message.hexalia.ritual.wrong_recipe");
            return true;
        }
        for (RitualBrazierBlockEntity brazier : match.usedBraziers) {
            class_2680 bs = world.method_8320(brazier.method_11016());
            if (!bs.method_28498((class_2769)RitualBrazierBlock.SALTED) || ((Boolean)bs.method_11654((class_2769)RitualBrazierBlock.SALTED)).booleanValue()) continue;
            this.failWithMessage(world, pos, player, "message.hexalia.ritual.missing_salt");
            return true;
        }
        List<class_2338> grownCrops = this.findFullyGrownCrops(world, pos, 8, 8);
        if (grownCrops.size() < 8) {
            this.failWithMessage(world, pos, player, "message.hexalia.ritual.invalid_crops");
            return true;
        }
        int duration = match.usedBraziers.size() * 40;
        tableBE.startTransformation(match.recipe.method_8110(world.method_30349()).method_7972(), duration, match.usedBraziers);
        tableBE.setGrownCropPositions(grownCrops);
        for (RitualBrazierBlockEntity brazier : match.usedBraziers) {
            class_2338 bp = brazier.method_11016();
            class_2680 bs = world.method_8320(bp);
            if (!bs.method_28498((class_2769)RitualBrazierBlock.SALTED) || !((Boolean)bs.method_11654((class_2769)RitualBrazierBlock.SALTED)).booleanValue()) continue;
            world.method_8652(bp, (class_2680)bs.method_11657((class_2769)RitualBrazierBlock.SALTED, (Comparable)Boolean.valueOf(false)), 3);
        }
        this.playInteractionSound(world, pos);
        this.spawnParticles(world, pos, class_2398.field_11203, 5, 10);
        return true;
    }

    @Nullable
    private MatchResult findMatchingRecipe(class_1937 world, class_1799 tableItem, List<RitualBrazierBlockEntity> availableBraziers) {
        class_1277 inv = new class_1277(4);
        inv.method_5447(0, tableItem.method_7972());
        List candidates = world.method_8433().method_17877(ModRecipes.RITUAL_TABLE_TYPE, (class_1263)inv, world);
        for (RitualTableRecipe recipe : candidates) {
            class_2371<class_1856> ings = recipe.method_8117();
            if (ings.isEmpty() || !((class_1856)ings.get(0)).method_8093(tableItem)) continue;
            List needed = ings.subList(1, ings.size());
            ArrayList<RitualBrazierBlockEntity> pool = new ArrayList<RitualBrazierBlockEntity>(availableBraziers);
            ArrayList<RitualBrazierBlockEntity> used = new ArrayList<RitualBrazierBlockEntity>();
            boolean ok = true;
            for (class_1856 ing : needed) {
                int idx = -1;
                for (int i = 0; i < pool.size(); ++i) {
                    if (!ing.method_8093(((RitualBrazierBlockEntity)((Object)pool.get(i))).getStoredItem())) continue;
                    idx = i;
                    break;
                }
                if (idx == -1) {
                    ok = false;
                    break;
                }
                used.add((RitualBrazierBlockEntity)((Object)pool.remove(idx)));
            }
            if (!ok) continue;
            return new MatchResult(recipe, used);
        }
        return null;
    }

    private void failWithMessage(class_1937 world, class_2338 pos, class_1657 player, String key) {
        this.spawnParticles(world, pos, class_2398.field_11251, 8, 12);
        if (!world.field_9236) {
            player.method_7353((class_2561)class_2561.method_43471((String)key), true);
        }
    }

    private List<class_2338> findFullyGrownCrops(class_1937 world, class_2338 center, int requiredCount, int radius) {
        ArrayList<class_2338> found = new ArrayList<class_2338>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                class_2302 crop;
                class_2338 check = center.method_10069(dx, 0, dz);
                class_2680 st = world.method_8320(check);
                class_2248 class_22482 = st.method_26204();
                if (!(class_22482 instanceof class_2302) || !(crop = (class_2302)class_22482).method_9825(st)) continue;
                found.add(check);
                if (found.size() < requiredCount) continue;
                return found;
            }
        }
        return found;
    }

    private void addItemToBlock(class_1799 stack, class_1937 world, class_2338 pos, class_1657 player, RitualTableBlockEntity table) {
        table.method_5447(0, stack);
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        this.playInteractionSound(world, pos);
    }

    private void removeItemFromBlock(class_1937 world, class_2338 pos, class_1657 player, RitualTableBlockEntity table) {
        class_1799 onTable = table.method_5438(0);
        if (!player.method_31549().field_7477) {
            player.method_6122(class_1268.field_5808, onTable);
        }
        table.method_5448();
        this.playInteractionSound(world, pos);
    }

    private void spawnParticles(class_1937 world, class_2338 pos, class_2400 type, int min, int max) {
        if (world instanceof class_3218) {
            class_3218 server = (class_3218)world;
            int count = ThreadLocalRandom.current().nextInt(min, max);
            for (int i = 0; i < count; ++i) {
                double x = (double)pos.method_10263() + 0.5 + ThreadLocalRandom.current().nextDouble(-0.5, 0.5);
                double y = (double)pos.method_10264() + 1.0 + ThreadLocalRandom.current().nextDouble(0.0, 0.5);
                double z = (double)pos.method_10260() + 0.5 + ThreadLocalRandom.current().nextDouble(-0.5, 0.5);
                server.method_14199((class_2394)type, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void playInteractionSound(class_1937 world, class_2338 pos) {
        world.method_8396(null, pos, class_3417.field_40974, class_3419.field_15245, 0.8f, 0.5f);
        world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 0.8f, 0.5f);
    }

    private static final class MatchResult {
        final RitualTableRecipe recipe;
        final List<RitualBrazierBlockEntity> usedBraziers;

        MatchResult(RitualTableRecipe recipe, List<RitualBrazierBlockEntity> usedBraziers) {
            this.recipe = recipe;
            this.usedBraziers = usedBraziers;
        }
    }
}

