/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom.censer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.WindsongBlock;
import net.astralya.hexalia.block.custom.censer.HerbCombination;
import net.astralya.hexalia.block.entity.custom.CenserBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.sound.ModSoundEvents;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4140;
import net.minecraft.class_5354;
import net.minecraft.class_5575;

public class CenserEffectHandler {
    private static final Map<class_1937, Set<class_2338>> UNDEAD_VEIL_CACHE = new WeakHashMap<class_1937, Set<class_2338>>();
    private static final int MINERS_RESPITE_EFFECT_REFRESH_TICKS = 300;
    public static final Map<HerbCombination, BiConsumer<class_1937, class_2338>> EFFECTS = Map.of(new HerbCombination(ModItems.SIREN_KELP, ModBlocks.SPIRIT_BLOOM.method_8389()), CenserEffectHandler::applyFireproofPresence, new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()), CenserEffectHandler::applyUndeadVeil, new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModItems.SIREN_KELP), CenserEffectHandler::applyLivestockComfort, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()), CenserEffectHandler::applyMinersRespite, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModItems.SIREN_KELP), CenserEffectHandler::applyFishersBoon, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.GHOST_FERN.method_8389()), CenserEffectHandler::applySuctionZone);
    private static final Map<class_2338, ActiveCenserEffect> ACTIVE_EFFECTS = new HashMap<class_2338, ActiveCenserEffect>();
    private static final Map<class_1937, Set<EffectArea>> ACTIVE_EFFECT_AREAS = new HashMap<class_1937, Set<EffectArea>>();

    private static int areaRadius() {
        return Math.max(1, Configuration.common().functional_blocks.censerEffectRadius);
    }

    private static int effectDuration() {
        return Math.max(1, Configuration.common().functional_blocks.censerEffectDuration);
    }

    public static void registerActiveEffect(class_1937 world, class_2338 pos, HerbCombination combo, int remainingTime) {
        if (world.method_8608()) {
            return;
        }
        ACTIVE_EFFECTS.put(pos, new ActiveCenserEffect(null, remainingTime, combo));
        CenserEffectHandler.applyEffects(world, pos, combo);
        EffectType effectType = CenserEffectHandler.getEffectTypeForCombination(combo);
        if (effectType != null) {
            CenserEffectHandler.registerEffectArea(world, pos, effectType, remainingTime);
        }
    }

    public static void removeActiveEffect(class_2338 pos) {
        ACTIVE_EFFECTS.remove(pos);
    }

    private static void registerEffectArea(class_1937 world, class_2338 pos, EffectType effectType, int duration) {
        ACTIVE_EFFECT_AREAS.computeIfAbsent(world, k -> new HashSet()).add(new EffectArea(pos.method_10062(), effectType, duration));
        if (effectType == EffectType.UNDEAD_VEIL) {
            UNDEAD_VEIL_CACHE.computeIfAbsent(world, k -> new HashSet()).add(pos.method_10062());
        }
    }

    public static void removeEffectArea(class_1937 world, class_2338 pos) {
        if (ACTIVE_EFFECT_AREAS.containsKey(world)) {
            ACTIVE_EFFECT_AREAS.get(world).removeIf(area -> area.getCenter().equals((Object)pos));
            if (UNDEAD_VEIL_CACHE.containsKey(world)) {
                UNDEAD_VEIL_CACHE.get(world).remove(pos);
            }
        }
    }

    public static void startEffect(class_1937 world, class_2338 pos, HerbCombination combo) {
        class_2586 class_25862;
        if (world.method_8608()) {
            return;
        }
        int dur = CenserEffectHandler.effectDuration();
        ACTIVE_EFFECTS.put(pos, new ActiveCenserEffect(null, dur, combo));
        CenserEffectHandler.applyEffects(world, pos, combo);
        EffectType effectType = CenserEffectHandler.getEffectTypeForCombination(combo);
        if (effectType != null) {
            CenserEffectHandler.registerEffectArea(world, pos, effectType, dur);
        }
        if ((class_25862 = world.method_8321(pos)) instanceof CenserBlockEntity) {
            CenserBlockEntity censer = (CenserBlockEntity)class_25862;
            censer.setActiveCombination(combo);
            censer.setBurnTime(dur);
        }
        if (effectType == EffectType.MINERS_RESPITE && world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            CenserEffectHandler.repairAnvilsInArea(sw, pos, CenserEffectHandler.areaRadius());
        }
    }

    public static boolean isUndeadVeilActiveInArea(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return false;
        }
        Set<class_2338> veilPositions = UNDEAD_VEIL_CACHE.get(world);
        if (veilPositions == null || veilPositions.isEmpty()) {
            return false;
        }
        double r2 = (double)CenserEffectHandler.areaRadius() * (double)CenserEffectHandler.areaRadius();
        for (class_2338 center : veilPositions) {
            if (!(pos.method_10262((class_2382)center) <= r2)) continue;
            return true;
        }
        return false;
    }

    public static void updateEffects(class_1937 world) {
        Iterator<Map.Entry<class_2338, ActiveCenserEffect>> it = ACTIVE_EFFECTS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<class_2338, ActiveCenserEffect> entry = it.next();
            class_2338 pos = entry.getKey();
            ActiveCenserEffect effect = entry.getValue();
            effect.decrementDuration();
            if (effect.isExpired()) {
                CenserEffectHandler.clearEffect(world, pos, effect.combo());
                it.remove();
                continue;
            }
            CenserEffectHandler.applyEffects(world, pos, effect.combo());
        }
        if (ACTIVE_EFFECT_AREAS.containsKey(world)) {
            Iterator<EffectArea> areaIt = ACTIVE_EFFECT_AREAS.get(world).iterator();
            while (areaIt.hasNext()) {
                EffectArea area = areaIt.next();
                area.decrementTicks();
                if (!area.isExpired()) continue;
                areaIt.remove();
            }
        }
    }

    private static void clearEffect(class_1937 world, class_2338 pos, HerbCombination combo) {
        class_238 area = new class_238(pos).method_1014((double)CenserEffectHandler.areaRadius());
        world.method_18023((class_5575)class_1299.field_6097, area, class_1301.field_6154).forEach(player -> player.method_5752().remove("HexaliaFishersBoon"));
        CenserEffectHandler.removeEffectArea(world, pos);
    }

    public static void applyEffects(class_1937 world, class_2338 pos, HerbCombination combo) {
        if (world.method_8608()) {
            return;
        }
        EFFECTS.getOrDefault(combo, (l, p) -> {}).accept(world, pos);
    }

    private static void applyFireproofPresence(class_1937 world, class_2338 pos) {
        class_238 area = new class_238(pos).method_1014((double)CenserEffectHandler.areaRadius());
        List living = world.method_8390(class_1309.class, area, class_1301.field_6154);
        for (class_1309 e : living) {
            e.method_20803(0);
            e.method_6092(new class_1293(class_1294.field_5918, 100, 0, false, false, true));
        }
    }

    private static void applyUndeadVeil(class_1937 world, class_2338 pos) {
        class_238 area = new class_238(pos).method_1014((double)CenserEffectHandler.areaRadius());
        world.method_8390(class_1308.class, area, e -> e instanceof class_1588 && e.method_5864().method_5891() == class_1311.field_6302).forEach(mob -> {
            mob.method_5980(null);
            mob.method_6015(null);
            if (mob instanceof class_5354) {
                class_5354 angerable = (class_5354)mob;
                angerable.method_29513(null);
                angerable.method_29514(0);
            }
            if (!mob.method_6059(class_1294.field_5912)) {
                mob.method_6092(new class_1293(class_1294.field_5912, 140, 0, false, false));
            }
            mob.method_16826(0);
            try {
                if (mob.method_18868() != null) {
                    mob.method_18868().method_18875(class_4140.field_22355);
                    mob.method_18868().method_18875(class_4140.field_22333);
                    mob.method_18868().method_18875(class_4140.field_25361);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private static void applyLivestockComfort(class_1937 world, class_2338 pos) {
        class_238 area = new class_238(pos).method_1014((double)CenserEffectHandler.areaRadius());
        world.method_8390(class_1296.class, area, class_1301.field_6154).forEach(passive -> {
            if (passive.method_5618() < 0) {
                passive.method_5620((int)((double)passive.method_5618() * 0.5), true);
            }
        });
    }

    private static void applyMinersRespite(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_238 area = new class_238(pos).method_1014((double)CenserEffectHandler.areaRadius());
        for (class_1657 player : serverWorld.method_8390(class_1657.class, area, class_1301.field_6154)) {
            player.method_6092(new class_1293(class_1294.field_5925, 300, 0, false, false, true));
            player.method_6092(new class_1293(class_1294.field_5917, 300, 1, false, false, true));
        }
    }

    private static void repairAnvilsInArea(class_3218 world, class_2338 center, int radius) {
        class_238 area = new class_238(center).method_1014((double)radius);
        class_2338 min = class_2338.method_49637((double)area.field_1323, (double)area.field_1322, (double)area.field_1321);
        class_2338 max = class_2338.method_49637((double)area.field_1320, (double)area.field_1325, (double)area.field_1324);
        for (class_2338 bp : class_2338.method_10097((class_2338)min, (class_2338)max)) {
            class_2680 state = world.method_8320(bp);
            if (!(state.method_26204() instanceof class_2199)) continue;
            class_2350 facing = state.method_28498((class_2769)class_2199.field_9883) ? (class_2350)state.method_11654((class_2769)class_2199.field_9883) : class_2350.field_11043;
            class_2680 repaired = null;
            if (state.method_27852(class_2246.field_10414)) {
                repaired = class_2246.field_10105.method_9564();
            } else if (state.method_27852(class_2246.field_10105)) {
                repaired = class_2246.field_10535.method_9564();
            }
            if (repaired == null) continue;
            if (repaired.method_28498((class_2769)class_2199.field_9883)) {
                repaired = (class_2680)repaired.method_11657((class_2769)class_2199.field_9883, (Comparable)facing);
            }
            world.method_8652(bp, repaired, 3);
            world.method_8396(null, bp, class_3417.field_14559, class_3419.field_15245, 0.35f, 1.2f);
            world.method_14199((class_2394)class_2398.field_11211, (double)bp.method_10263() + 0.5, (double)bp.method_10264() + 1.0, (double)bp.method_10260() + 0.5, 3, 0.25, 0.15, 0.25, 0.0);
        }
    }

    private static void applyFishersBoon(class_1937 world, class_2338 pos) {
        world.method_18023((class_5575)class_1299.field_6097, new class_238(pos).method_1014((double)CenserEffectHandler.areaRadius()), class_1301.field_6154).forEach(player -> {
            class_2487 nbt = player.method_5647(new class_2487());
            nbt.method_10556("HexaliaFishersBoon", true);
            player.method_5651(nbt);
        });
    }

    private static void applySuctionZone(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        int r = CenserEffectHandler.areaRadius();
        class_238 area = new class_238(pos).method_1014((double)r);
        List items = world.method_18023(class_5575.method_31795(class_1542.class), area, class_1301.field_6154);
        if (items.isEmpty()) {
            return;
        }
        boolean hasWindsong = class_2338.method_20437((class_2338)pos.method_10069(-r, -r, -r), (class_2338)pos.method_10069(r, r, r)).anyMatch(p -> world.method_8320(p).method_26204() instanceof WindsongBlock);
        List<class_2614> hoppers = hasWindsong ? class_2338.method_20437((class_2338)class_2338.method_49637((double)area.field_1323, (double)area.field_1322, (double)area.field_1321), (class_2338)class_2338.method_49637((double)area.field_1320, (double)area.field_1325, (double)area.field_1324)).map(arg_0 -> ((class_1937)world).method_8321(arg_0)).filter(be -> be instanceof class_2614).map(be -> (class_2614)be).toList() : Collections.emptyList();
        for (class_1542 item : items) {
            class_1657 nearest;
            if (item.method_31481()) continue;
            boolean itemAbsorbed = false;
            if (!hoppers.isEmpty()) {
                for (class_2614 hopper : hoppers) {
                    class_1799 remaining = class_2614.method_11260(null, (class_1263)hopper, (class_1799)item.method_6983().method_7972(), null);
                    if (remaining.method_7960()) {
                        itemAbsorbed = true;
                        break;
                    }
                    if (remaining.method_7947() >= item.method_6983().method_7947()) continue;
                    item.method_6979(remaining);
                    CenserEffectHandler.playSuctionEffects(serverWorld, item.method_19538());
                }
            }
            if (!itemAbsorbed && (nearest = (class_1657)CenserEffectHandler.findNearestEntity(item.method_19538(), world.method_18023(class_5575.method_31795(class_1657.class), area, class_1301.field_6154))) != null) {
                item.method_5694(nearest);
            }
            if (!itemAbsorbed) continue;
            CenserEffectHandler.playSuctionEffects(serverWorld, item.method_19538());
            item.method_31472();
        }
    }

    private static void playSuctionEffects(class_3218 world, class_243 pos) {
        world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, ModSoundEvents.WIND_BURST, class_3419.field_15245, 0.7f, 0.9f + world.field_9229.method_43057() * 0.2f);
        for (int i = 0; i < 8; ++i) {
            double angle = world.field_9229.method_43058() * 2.0 * Math.PI;
            double r = world.field_9229.method_43058() * 0.5;
            double x = pos.field_1352 + r * Math.cos(angle);
            double z = pos.field_1350 + r * Math.sin(angle);
            double y = pos.field_1351 + world.field_9229.method_43058() * 0.5;
            world.method_14199((class_2394)class_2398.field_11245, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private static <T extends class_1297> T findNearestEntity(class_243 position, List<T> entities) {
        class_1297 nearest = null;
        double best = Double.MAX_VALUE;
        for (class_1297 e : entities) {
            double d = position.method_1025(e.method_19538());
            if (!(d < best)) continue;
            best = d;
            nearest = e;
        }
        return (T)nearest;
    }

    public static boolean isValidCombination(class_1792 i1, class_1792 i2) {
        return EFFECTS.containsKey(new HerbCombination(i1, i2));
    }

    public static void clearPlayerEffectsInRange(class_1937 world, class_2338 pos) {
        class_238 area = new class_238(pos).method_1014((double)CenserEffectHandler.areaRadius());
        world.method_18023((class_5575)class_1299.field_6097, area, class_1301.field_6154).forEach(player -> {
            class_2487 nbt = player.method_5647(new class_2487());
            nbt.method_10551("HexaliaFishersBoon");
            player.method_5651(nbt);
        });
        CenserEffectHandler.removeEffectArea(world, pos);
    }

    public static boolean isEffectActiveInArea(class_1937 world, class_2338 pos, EffectType type) {
        if (!(world instanceof class_3218)) {
            return false;
        }
        Set<EffectArea> areas = ACTIVE_EFFECT_AREAS.get(world);
        if (areas == null || areas.isEmpty()) {
            return false;
        }
        double r2 = (double)CenserEffectHandler.areaRadius() * (double)CenserEffectHandler.areaRadius();
        for (EffectArea a : areas) {
            if (a.getEffectType() != type || !(pos.method_10262((class_2382)a.getCenter()) <= r2)) continue;
            return true;
        }
        return false;
    }

    private static EffectType getEffectTypeForCombination(HerbCombination combo) {
        Map<HerbCombination, EffectType> map = Map.of(new HerbCombination(ModItems.SIREN_KELP, ModBlocks.SPIRIT_BLOOM.method_8389()), EffectType.FIREPROOF_PRESENCE, new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()), EffectType.UNDEAD_VEIL, new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModItems.SIREN_KELP), EffectType.LIVESTOCK_COMFORT, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()), EffectType.MINERS_RESPITE, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModItems.SIREN_KELP), EffectType.FISHERS_BOON, new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.GHOST_FERN.method_8389()), EffectType.SUCTION_ZONE);
        return map.getOrDefault(combo, null);
    }

    public static String getMessageKeyForCombination(HerbCombination combo) {
        if (combo.equals(new HerbCombination(ModItems.SIREN_KELP, ModBlocks.SPIRIT_BLOOM.method_8389()))) {
            return "message.hexalia.censer.fireproof_presence";
        }
        if (combo.equals(new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()))) {
            return "message.hexalia.censer.undead_veil";
        }
        if (combo.equals(new HerbCombination(ModBlocks.GHOST_FERN.method_8389(), ModItems.SIREN_KELP))) {
            return "message.hexalia.censer.livestock_comfort";
        }
        if (combo.equals(new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.SPIRIT_BLOOM.method_8389()))) {
            return "message.hexalia.censer.miners_respite";
        }
        if (combo.equals(new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModItems.SIREN_KELP))) {
            return "message.hexalia.censer.fishers_boon";
        }
        if (combo.equals(new HerbCombination(ModBlocks.DREAMSHROOM.method_8389(), ModBlocks.GHOST_FERN.method_8389()))) {
            return "message.hexalia.censer.suction_zone";
        }
        return "message.hexalia.censer.generic_effect";
    }

    private static class ActiveCenserEffect {
        private final EffectType type;
        private int duration;
        private final HerbCombination combo;

        public ActiveCenserEffect(EffectType type, int duration, HerbCombination combo) {
            this.type = type;
            this.duration = duration;
            this.combo = combo;
        }

        public void decrementDuration() {
            --this.duration;
        }

        public boolean isExpired() {
            return this.duration <= 0;
        }

        public HerbCombination combo() {
            return this.combo;
        }
    }

    public static enum EffectType {
        FIREPROOF_PRESENCE,
        UNDEAD_VEIL,
        LIVESTOCK_COMFORT,
        MINERS_RESPITE,
        FISHERS_BOON,
        SUCTION_ZONE;

    }

    public static class EffectArea {
        private final class_2338 center;
        private final EffectType effectType;
        private int remainingTicks;

        public EffectArea(class_2338 center, EffectType effectType, int duration) {
            this.center = center;
            this.effectType = effectType;
            this.remainingTicks = duration;
        }

        public class_2338 getCenter() {
            return this.center;
        }

        public EffectType getEffectType() {
            return this.effectType;
        }

        public boolean containsPos(class_2338 pos) {
            return pos.method_19771((class_2382)this.center, (double)CenserEffectHandler.areaRadius());
        }

        public void decrementTicks() {
            --this.remainingTicks;
        }

        public boolean isExpired() {
            return this.remainingTicks <= 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EffectArea that = (EffectArea)o;
            return this.center.equals((Object)that.center) && this.effectType == that.effectType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.center, this.effectType});
        }
    }
}

