/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.Collections;
import java.util.Optional;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.HeatingBlock;
import net.astralya.hexalia.block.entity.custom.SyncBlockEntity;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.SmallCauldronRecipe;
import net.astralya.hexalia.screen.custom.SmallCauldronScreenHandler;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;

public class SmallCauldronBlockEntity
extends SyncBlockEntity
implements ExtendedScreenHandlerFactory,
HeatingBlock,
class_1263 {
    private static final int SIZE = 5;
    private static final int INPUT_SLOT_1 = 0;
    private static final int INPUT_SLOT_2 = 1;
    private static final int INPUT_SLOT_3 = 2;
    private static final int OUTPUT_SLOT = 3;
    private static final int BOTTLE_SLOT = 4;
    private static final int DEFAULT_MAX_PROGRESS = 175;
    private final class_2371<class_1799> items = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private int progress = 0;
    private int maxProgress = 175;
    @Nullable
    private class_1657 lastInteractedPlayer;
    private final class_3913 properties = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> SmallCauldronBlockEntity.this.progress;
                case 1 -> SmallCauldronBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    SmallCauldronBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    SmallCauldronBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public SmallCauldronBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.SMALL_CAULDRON, pos, state);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world == null || world.field_9236) {
            return;
        }
        if (this.hasRecipe() && this.isOutputSlotEmptyOrReceivable() && this.isHeated()) {
            this.increaseCraftingProgress();
            this.markDirtyAndSync();
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.hexalia.small_cauldron");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new SmallCauldronScreenHandler(syncId, inv, this, this.properties);
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("small_cauldron.progress", this.progress);
        nbt.method_10569("small_cauldron.max_progress", this.maxProgress);
        class_1262.method_5426((class_2487)nbt, this.items);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.progress = nbt.method_10550("small_cauldron.progress");
        this.maxProgress = nbt.method_10550("small_cauldron.max_progress");
        Collections.fill(this.items, class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.items);
    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public int method_5439() {
        return 5;
    }

    public boolean method_5442() {
        for (class_1799 s : this.items) {
            if (s.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return slot >= 0 && slot < 5 ? (class_1799)this.items.get(slot) : class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        if (slot < 0 || slot >= 5 || amount <= 0) {
            return class_1799.field_8037;
        }
        class_1799 current = (class_1799)this.items.get(slot);
        if (current.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 taken = current.method_7971(amount);
        if (current.method_7960()) {
            this.items.set(slot, (Object)class_1799.field_8037);
        }
        this.markDirtyAndSync();
        return taken;
    }

    public class_1799 method_5441(int slot) {
        if (slot < 0 || slot >= 5) {
            return class_1799.field_8037;
        }
        class_1799 out = (class_1799)this.items.get(slot);
        this.items.set(slot, (Object)class_1799.field_8037);
        this.markDirtyAndSync();
        return out;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot < 0 || slot >= 5) {
            return;
        }
        this.items.set(slot, (Object)(stack.method_7960() ? class_1799.field_8037 : stack.method_7972()));
        if (!((class_1799)this.items.get(slot)).method_7960() && ((class_1799)this.items.get(slot)).method_7947() > ((class_1799)this.items.get(slot)).method_7914()) {
            this.items.set(slot, (Object)((class_1799)this.items.get(slot)).method_46651(((class_1799)this.items.get(slot)).method_7914()));
        }
        this.markDirtyAndSync();
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863 == null) {
            return false;
        }
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        for (int i = 0; i < 5; ++i) {
            this.items.set(i, (Object)class_1799.field_8037);
        }
        this.markDirtyAndSync();
    }

    public boolean isHeated() {
        class_1937 w = this.method_10997();
        return w != null && this.isHeated(w, this.method_11016());
    }

    public void setLastInteractedPlayer(class_1657 player) {
        this.lastInteractedPlayer = player;
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 175;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        class_1799 out = (class_1799)this.items.get(3);
        return out.method_7960() || out.method_7947() < out.method_7914();
    }

    private boolean hasRecipe() {
        class_1937 w = this.method_10997();
        if (w == null) {
            return false;
        }
        class_1277 inv = new class_1277(4);
        inv.method_5447(0, (class_1799)this.items.get(0));
        inv.method_5447(1, (class_1799)this.items.get(1));
        inv.method_5447(2, (class_1799)this.items.get(2));
        inv.method_5447(3, (class_1799)this.items.get(4));
        Optional match = w.method_8433().method_8132(ModRecipes.SMALL_CAULDRON_TYPE, (class_1263)inv, w);
        if (!match.isPresent()) {
            return false;
        }
        SmallCauldronRecipe recipe = (SmallCauldronRecipe)match.get();
        class_1799 result = recipe.method_8110(w.method_30349());
        this.maxProgress = recipe.getBrewTime();
        return this.canInsertAmountIntoOutput(result.method_7947()) && this.canInsertItemIntoOutput(result);
    }

    private void craftItem() {
        class_1937 w = this.method_10997();
        if (w == null) {
            return;
        }
        class_1277 inv = new class_1277(4);
        inv.method_5447(0, (class_1799)this.items.get(0));
        inv.method_5447(1, (class_1799)this.items.get(1));
        inv.method_5447(2, (class_1799)this.items.get(2));
        inv.method_5447(3, (class_1799)this.items.get(4));
        Optional match = w.method_8433().method_8132(ModRecipes.SMALL_CAULDRON_TYPE, (class_1263)inv, w);
        if (!match.isPresent()) {
            return;
        }
        SmallCauldronRecipe recipe = (SmallCauldronRecipe)match.get();
        class_1799 result = recipe.method_8110(w.method_30349());
        class_1799 current = (class_1799)this.items.get(3);
        this.items.set(3, (Object)new class_1799((class_1935)result.method_7909(), current.method_7947() + result.method_7947()));
        for (int i = 0; i < 3; ++i) {
            this.decrementSlot(i);
        }
        if (!recipe.getBottleSlot().method_8103()) {
            this.decrementSlot(4);
        }
        if (this.lastInteractedPlayer != null) {
            this.grantExperience(this.lastInteractedPlayer, recipe.getExperience());
        }
        this.markDirtyAndSync();
    }

    private void grantExperience(class_1657 player, float experience) {
        if (experience > 0.0f && !player.method_37908().field_9236) {
            player.method_7255((int)experience);
        }
    }

    private boolean canInsertItemIntoOutput(class_1799 output) {
        class_1799 out = (class_1799)this.items.get(3);
        return out.method_7960() || out.method_31574(output.method_7909());
    }

    private boolean canInsertAmountIntoOutput(int count) {
        class_1799 out = (class_1799)this.items.get(3);
        int max = out.method_7960() ? 64 : out.method_7914();
        int current = out.method_7947();
        return max >= current + count;
    }

    private void decrementSlot(int slot) {
        class_1799 s = (class_1799)this.items.get(slot);
        if (s.method_7960()) {
            return;
        }
        int remain = s.method_7947() - 1;
        this.items.set(slot, (Object)(remain > 0 ? s.method_46651(remain) : class_1799.field_8037));
    }

    private void markDirtyAndSync() {
        this.method_5431();
        class_1937 w = this.method_10997();
        if (w instanceof class_3218) {
            class_3218 sw = (class_3218)w;
            sw.method_14178().method_14128(this.method_11016());
            w.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }
}

