/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.List;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.sound.ModSoundEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class WindsongBlockEntity
extends class_2586 {
    private int activeTicks = 0;
    private long activationTime = -1L;
    private int duration = 0;
    private int particleCooldown = 0;

    public WindsongBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.WINDSONG, pos, state);
    }

    private static int cfgDuration() {
        return Math.max(1, Configuration.common().plants.windsongDuration);
    }

    private static int cfgRadius() {
        return Math.max(1, Configuration.common().plants.windsongEffectRadius);
    }

    public void activate() {
        this.activate(WindsongBlockEntity.cfgDuration());
    }

    public void activate(int customDuration) {
        this.activeTicks = this.duration = Math.max(1, customDuration);
        this.activationTime = this.field_11863 != null ? this.field_11863.method_8510() : -1L;
        this.method_5431();
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public int getDuration() {
        return this.duration;
    }

    public float getProgress() {
        return this.duration <= 0 ? 0.0f : Math.min(1.0f, (float)(this.duration - this.activeTicks) / (float)this.duration);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        long elapsed;
        int expected;
        if (this.activationTime != -1L && world != null && this.activeTicks > 0 && this.duration > 0 && Math.abs(this.activeTicks - (expected = this.duration - (int)(elapsed = world.method_8510() - this.activationTime))) > 5) {
            this.activeTicks = Math.max(0, expected);
        }
        if (!this.isActive()) {
            return;
        }
        --this.activeTicks;
        if (world instanceof class_3218) {
            class_3218 server = (class_3218)world;
            int radius = WindsongBlockEntity.cfgRadius();
            class_238 area = new class_238(pos).method_1014((double)radius);
            List projectiles = server.method_8390(class_1297.class, area, e -> e instanceof class_1676);
            for (class_1297 projectile : projectiles) {
                if (projectile.method_31481()) continue;
                this.discardProjectile(server, projectile);
            }
            this.emitParticles(server, pos, radius);
        }
        if (this.activeTicks <= 0) {
            world.method_8396(null, pos, ModSoundEvents.WIND_BURST, class_3419.field_15245, 1.0f, 1.0f);
            world.method_22352(pos, false);
        } else {
            this.method_5431();
        }
    }

    private void discardProjectile(class_3218 world, class_1297 projectile) {
        world.method_43128(null, projectile.method_23317(), projectile.method_23318(), projectile.method_23321(), ModSoundEvents.WIND_DEFLECT, class_3419.field_15245, 1.0f, 1.0f);
        class_243 p = projectile.method_19538();
        for (int i = 0; i < 5; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            double r = Math.random() * 0.5;
            double x = p.field_1352 + r * Math.cos(angle);
            double z = p.field_1350 + r * Math.sin(angle);
            double y = p.field_1351 + Math.random() * 0.5;
            world.method_14199((class_2394)class_2398.field_11245, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
        projectile.method_31472();
    }

    private void emitParticles(class_3218 world, class_2338 pos, int radius) {
        if (this.particleCooldown > 0) {
            --this.particleCooldown;
            return;
        }
        class_243 c = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        float progress = this.getProgress();
        int particleCount = Math.max(1, (int)(3.0f * (1.0f - progress * 0.5f)));
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            double r = Math.random() * (double)radius;
            double x = c.field_1352 + r * Math.cos(angle);
            double z = c.field_1350 + r * Math.sin(angle);
            double y = c.field_1351 + Math.random() * 2.0;
            world.method_14199((class_2394)class_2398.field_11204, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
        }
        this.particleCooldown = 5;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.activeTicks = nbt.method_10550("ActiveTicks");
        this.activationTime = nbt.method_10537("ActivationTime");
        this.duration = nbt.method_10545("Duration") ? nbt.method_10550("Duration") : WindsongBlockEntity.cfgDuration();
        this.particleCooldown = nbt.method_10550("ParticleCooldown");
        if (this.activationTime != -1L && this.field_11863 != null && this.activeTicks > 0 && this.duration > 0) {
            long elapsed = this.field_11863.method_8510() - this.activationTime;
            this.activeTicks = Math.max(0, this.duration - (int)elapsed);
        }
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("ActiveTicks", this.activeTicks);
        nbt.method_10544("ActivationTime", this.activationTime);
        nbt.method_10569("Duration", this.duration);
        nbt.method_10569("ParticleCooldown", this.particleCooldown);
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        nbt.method_10569("ActiveTicks", this.activeTicks);
        nbt.method_10544("ActivationTime", this.activationTime);
        nbt.method_10569("Duration", this.duration);
        nbt.method_10569("ParticleCooldown", this.particleCooldown);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

