/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.astralya.hexalia.recipe.ModRecipes;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SmallCauldronRecipeBuilder
implements class_5797 {
    private final class_2371<class_1856> ingredients = class_2371.method_10211();
    private class_1856 bottle = class_1856.field_9017;
    private class_1799 result = class_1799.field_8037;
    private float experience = 0.0f;
    private int brewTime = 200;
    private final class_161.class_162 advancement = class_161.class_162.method_707();

    public static SmallCauldronRecipeBuilder smallCauldron() {
        return new SmallCauldronRecipeBuilder();
    }

    public SmallCauldronRecipeBuilder addIngredient(class_1935 item) {
        this.ingredients.add((Object)class_1856.method_8091((class_1935[])new class_1935[]{item}));
        return this;
    }

    public SmallCauldronRecipeBuilder bottle(class_1935 item) {
        this.bottle = class_1856.method_8091((class_1935[])new class_1935[]{item});
        return this;
    }

    public SmallCauldronRecipeBuilder result(class_1935 item, int count) {
        this.result = new class_1799(item, count);
        return this;
    }

    public SmallCauldronRecipeBuilder experience(float xp) {
        this.experience = xp;
        return this;
    }

    public SmallCauldronRecipeBuilder brewTime(int ticks) {
        this.brewTime = ticks;
        return this;
    }

    public SmallCauldronRecipeBuilder criterion(String name, class_184 conditions) {
        this.advancement.method_709(name, conditions);
        return this;
    }

    public SmallCauldronRecipeBuilder group(@Nullable String group) {
        return this;
    }

    public class_1792 method_36441() {
        return this.result.method_7909();
    }

    public void method_17972(Consumer<class_2444> exporter, class_2960 recipeId) {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("Small Cauldron recipe needs at least 1 ingredient.");
        }
        if (this.bottle == class_1856.field_9017) {
            throw new IllegalStateException("Small Cauldron recipe requires a bottle ingredient.");
        }
        if (this.result.method_7960()) {
            throw new IllegalStateException("Small Cauldron recipe requires a result item.");
        }
        this.advancement.method_708(new class_2960("recipes/root")).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId));
        class_2960 advId = new class_2960(recipeId.method_12836(), "recipes/small_cauldron/" + recipeId.method_12832());
        exporter.accept(new JsonBuilder(recipeId, this.ingredients, this.bottle, this.result, this.experience, this.brewTime, this.advancement, advId));
    }

    public static class JsonBuilder
    implements class_2444 {
        private final class_2960 id;
        private final class_2371<class_1856> ingredients;
        private final class_1856 bottle;
        private final class_1799 result;
        private final float experience;
        private final int brewTime;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;

        public JsonBuilder(class_2960 id, class_2371<class_1856> ingredients, class_1856 bottle, class_1799 result, float experience, int brewTime, class_161.class_162 advancement, class_2960 advancementId) {
            this.id = id;
            this.ingredients = ingredients;
            this.bottle = bottle;
            this.result = result.method_7972();
            this.experience = experience;
            this.brewTime = brewTime;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void method_10416(JsonObject json) {
            JsonArray ingArr = new JsonArray();
            for (class_1856 ing : this.ingredients) {
                ingArr.add(ing.method_8089());
            }
            json.add("ingredients", (JsonElement)ingArr);
            json.add("bottle_slot", this.bottle.method_8089());
            JsonObject outputObj = new JsonObject();
            outputObj.addProperty("item", class_7923.field_41178.method_10221((Object)this.result.method_7909()).toString());
            if (this.result.method_7947() > 1) {
                outputObj.addProperty("count", (Number)this.result.method_7947());
            }
            json.add("output", (JsonElement)outputObj);
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("brew_time", (Number)this.brewTime);
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return ModRecipes.SMALL_CAULDRON_SERIALIZER;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

