/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.util;

import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3532;

public final class SunlightCheck {
    private final class_1937 world;
    private class_2338 pos;
    private final boolean needsRainCheck;
    private final float peakMultiplier;
    private boolean canSeeSun;

    public SunlightCheck(class_1937 world, class_2338 pos) {
        this.world = world;
        this.pos = pos;
        this.needsRainCheck = ((class_1959)world.method_23753(pos).comp_349()).method_48163();
        this.peakMultiplier = 1.0f;
    }

    public void moveTo(class_2338 newPos) {
        this.pos = newPos;
        this.recheckCanSeeSun();
    }

    public void recheckCanSeeSun() {
        this.canSeeSun = SunlightCheck.canSeeSun(this.world, this.pos);
    }

    public boolean canSeeSunNow() {
        return this.canSeeSun;
    }

    public float getPeakMultiplier() {
        return this.peakMultiplier;
    }

    public float getGenerationMultiplier() {
        if (!this.canSeeSun) {
            return 0.0f;
        }
        if (this.needsRainCheck && (this.world.method_8419() || this.world.method_8546())) {
            return this.peakMultiplier * 0.2f;
        }
        return this.peakMultiplier;
    }

    public static float getSunBrightness(class_1937 world, float tickDelta) {
        float t = world.method_30274(tickDelta);
        float curve = 1.0f - (class_3532.method_15362((float)(t * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        curve = class_3532.method_15363((float)curve, (float)0.0f, (float)1.0f);
        curve = 1.0f - curve;
        curve = (float)((double)curve * (1.0 - (double)(world.method_8430(tickDelta) * 5.0f) / 16.0));
        curve = (float)((double)curve * (1.0 - (double)(world.method_8478(tickDelta) * 5.0f) / 16.0));
        return curve * 0.8f + 0.2f;
    }

    public static boolean canSeeSun(class_1937 world, class_2338 pos) {
        if (world == null) {
            return false;
        }
        if (!world.method_8597().comp_642()) {
            return false;
        }
        if (world.method_8594() >= 4) {
            return false;
        }
        return world.method_8311(pos);
    }
}

