/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import com.mojang.serialization.MapCodec;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.custom.censer.CenserEffectHandler;
import net.astralya.hexalia.block.custom.censer.HerbCombination;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.CenserBlockEntity;
import net.astralya.hexalia.util.ModTags;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1786;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class CenserBlock
extends class_2237 {
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 LIT = class_2741.field_12548;
    public static final MapCodec<CenserBlock> CODEC = CenserBlock.method_54094(CenserBlock::new);

    public CenserBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_243 offset = state.method_26226(world, pos);
        return SHAPE.method_1096(offset.field_1352, offset.field_1351, offset.field_1350);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 clickedFace = ctx.method_8038();
        if (clickedFace.method_10166() == class_2350.class_2351.field_11052) {
            return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
        }
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)clickedFace);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof CenserBlockEntity)) {
            return class_9062.field_47731;
        }
        CenserBlockEntity censer = (CenserBlockEntity)be;
        class_1799 heldItem = player.method_5998(hand);
        if (heldItem.method_7909() instanceof class_1786 && !((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            class_1799 herb1 = censer.getItem(0);
            class_1799 herb2 = censer.getItem(1);
            if (herb1.method_7960() || herb2.method_7960()) {
                if (world.field_9236) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.hexalia.censer_not_full"), true);
                }
                return class_9062.field_47733;
            }
            HerbCombination combo = new HerbCombination(herb1.method_7909(), herb2.method_7909());
            if (!CenserEffectHandler.isValidCombination(herb1.method_7909(), herb2.method_7909())) {
                if (world.field_9236) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.hexalia.invalid_herb_combination"), true);
                }
                return class_9062.field_47733;
            }
            if (!world.field_9236) {
                this.sendEffectActivationMessage(world, pos, combo, player);
                censer.clearItems();
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true)), 3);
                censer.setActiveCombination(combo);
                censer.setBurnTime(Configuration.common().functional_blocks.censerEffectDuration);
                CenserEffectHandler.startEffect(world, pos, combo);
            } else {
                censer.clearItems();
            }
            if (!player.method_31549().field_7477 && heldItem.method_7963()) {
                heldItem.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
                if (heldItem.method_7960()) {
                    player.method_6122(hand, class_1799.field_8037);
                }
            }
            world.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.4f + 0.8f);
            return class_9062.field_47728;
        }
        if (heldItem.method_7909() instanceof class_1821 && ((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            if (!world.field_9236) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)), 3);
                censer.setBurnTime(0);
                censer.clearItems();
                censer.setActiveCombination(null);
                world.method_8396(null, pos, class_3417.field_15222, class_3419.field_15245, 0.5f, 1.0f);
            } else {
                censer.clearItems();
            }
            return class_9062.field_47728;
        }
        if (!((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            if (heldItem.method_7960()) {
                for (int i = 0; i < censer.getItems().size(); ++i) {
                    class_1799 inSlot = censer.getItem(i);
                    if (inSlot.method_7960()) continue;
                    class_1799 removed = censer.removeStack(i);
                    if (!player.method_31548().method_7394(removed)) {
                        player.method_7328(removed, false);
                    }
                    world.method_8396(null, pos, class_3417.field_14770, class_3419.field_15245, 0.5f, 1.0f);
                    return class_9062.field_47728;
                }
            } else if (heldItem.method_31573(ModTags.Items.HERBS)) {
                for (int i = 0; i < censer.getItems().size(); ++i) {
                    if (!censer.getItem(i).method_7960()) continue;
                    class_1799 toInsert = heldItem.method_7972();
                    toInsert.method_7939(1);
                    censer.setItem(i, toInsert);
                    if (!player.method_7337()) {
                        heldItem.method_7934(1);
                    }
                    world.method_8396(null, pos, class_3417.field_14667, class_3419.field_15245, 0.5f, 1.0f);
                    return class_9062.field_47728;
                }
            } else {
                if (world.field_9236) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.hexalia.invalid_item"), true);
                }
                return class_9062.field_47733;
            }
        }
        return class_9062.field_47731;
    }

    private void sendEffectActivationMessage(class_1937 world, class_2338 pos, HerbCombination combo, class_1657 activatingPlayer) {
        String key = CenserEffectHandler.getMessageKeyForCombination(combo);
        int radius = Configuration.common().functional_blocks.censerEffectRadius;
        class_238 area = new class_238(pos).method_1014((double)radius);
        for (class_1657 player : world.method_8390(class_1657.class, area, p -> true)) {
            if (player.method_5667().equals(activatingPlayer.method_5667()) || !(player instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)player;
            serverPlayer.method_43496((class_2561)class_2561.method_43471((String)key));
        }
        if (!world.field_9236 && activatingPlayer instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)activatingPlayer;
            serverPlayer.method_43496((class_2561)class_2561.method_43471((String)key));
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 be = world.method_8321(pos);
            if (be instanceof CenserBlockEntity) {
                CenserBlockEntity censer = (CenserBlockEntity)be;
                if (!world.field_9236) {
                    for (class_1799 stack : censer.getItems()) {
                        if (stack.method_7960()) continue;
                        class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack);
                    }
                    censer.clearItems();
                }
                CenserEffectHandler.clearPlayerEffectsInRange(world, pos);
                CenserEffectHandler.removeActiveEffect(pos);
                world.method_8544(pos);
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, LIT});
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CenserBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return CenserBlock.method_31618(type, ModBlockEntityTypes.CENSER, (w, p, s, be) -> be.tick(w, p, s));
    }
}

