/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class AstrylisBlockEntity
extends class_2586 {
    private long activationTime = -1L;
    private int duration = 0;
    private long lastBonemealTime = -1L;

    public AstrylisBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.ASTRYLIS, pos, state);
    }

    private static int cfgDuration() {
        return Math.max(1, Configuration.common().plants.astrylisDuration);
    }

    private static int cfgInterval() {
        return Math.max(1, Configuration.common().plants.astrylisBonemealInterval);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, AstrylisBlockEntity be) {
        long actualApplications;
        class_3218 server;
        block9: {
            block8: {
                if (!(world instanceof class_3218)) break block8;
                server = (class_3218)world;
                if (be.isActive()) break block9;
            }
            return;
        }
        long now = world.method_8510();
        long elapsed = now - be.activationTime;
        int interval = AstrylisBlockEntity.cfgInterval();
        if (elapsed >= (long)be.duration) {
            be.deactivate();
            be.syncToClient();
            return;
        }
        long expectedApplications = elapsed / (long)interval;
        long l = actualApplications = be.lastBonemealTime == -1L ? 0L : (be.lastBonemealTime - be.activationTime) / (long)interval + 1L;
        if (expectedApplications > actualApplications) {
            long missed = Math.min(expectedApplications - actualApplications, 5L);
            for (long i = 0L; i < missed; ++i) {
                AstrylisBlockEntity.applyBonemealToCropsAndSaplings(server, pos);
            }
            be.lastBonemealTime = now;
        } else if (elapsed % (long)interval == 0L && elapsed > 0L) {
            AstrylisBlockEntity.applyBonemealToCropsAndSaplings(server, pos);
            be.lastBonemealTime = now;
        }
        be.method_5431();
    }

    private static void applyBonemealToCropsAndSaplings(class_3218 world, class_2338 center) {
        class_2338.method_10097((class_2338)center.method_10069(-4, -2, -4), (class_2338)center.method_10069(4, 2, 4)).forEach(p -> {
            class_2680 s = world.method_8320(p);
            class_2248 patt0$temp = s.method_26204();
            if (patt0$temp instanceof class_2256) {
                class_2256 fert = (class_2256)patt0$temp;
                if ((s.method_26164(class_3481.field_20341) || s.method_26164(class_3481.field_15462)) && fert.method_9651((class_4538)world, p, s)) {
                    fert.method_9652(world, world.method_8409(), p, s);
                    world.method_14199((class_2394)class_2398.field_11211, (double)p.method_10263() + 0.5, (double)p.method_10264() + 0.5, (double)p.method_10260() + 0.5, 1, 0.2, 0.2, 0.2, 0.0);
                }
            }
        });
    }

    public boolean isActive() {
        return this.activationTime > 0L && this.field_11863 != null && this.field_11863.method_8510() >= this.activationTime;
    }

    public void activate(long gameTime) {
        this.activate(gameTime, AstrylisBlockEntity.cfgDuration());
    }

    public void activate(long gameTime, int customDuration) {
        this.activationTime = gameTime;
        this.duration = Math.max(1, customDuration);
        this.lastBonemealTime = -1L;
        this.method_5431();
        this.syncToClient();
    }

    public void deactivate() {
        this.activationTime = -1L;
        this.lastBonemealTime = -1L;
        this.method_5431();
        this.syncToClient();
    }

    public int getDuration() {
        return this.duration;
    }

    public float getProgress() {
        if (!this.isActive() || this.field_11863 == null || this.duration <= 0) {
            return 0.0f;
        }
        long elapsed = this.field_11863.method_8510() - this.activationTime;
        return Math.min(1.0f, (float)elapsed / (float)this.duration);
    }

    private void syncToClient() {
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10544("activationTime", this.activationTime);
        nbt.method_10569("duration", this.duration);
        nbt.method_10544("lastBonemealTime", this.lastBonemealTime);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.activationTime = nbt.method_10537("activationTime");
        this.duration = nbt.method_10545("duration") ? nbt.method_10550("duration") : AstrylisBlockEntity.cfgDuration();
        this.lastBonemealTime = nbt.method_10537("lastBonemealTime");
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = super.method_16887(registryLookup);
        nbt.method_10544("activationTime", this.activationTime);
        nbt.method_10569("duration", this.duration);
        nbt.method_10544("lastBonemealTime", this.lastBonemealTime);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

