/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.List;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1551;
import net.minecraft.class_1577;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class NautiliteBlockEntity
extends class_2586 {
    private int activeTicks = 0;
    private long activationTime = -1L;

    public NautiliteBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.NAUTILITE, pos, state);
    }

    private static int duration() {
        return Math.max(1, Configuration.common().plants.nautiliteDuration);
    }

    private static int effectRadius() {
        return Math.max(1, Configuration.common().plants.nautiliteEffectRadius);
    }

    public void activate() {
        this.activeTicks = NautiliteBlockEntity.duration();
        if (this.field_11863 != null) {
            this.activationTime = this.field_11863.method_8510();
        }
        this.method_5431();
    }

    public boolean isActive() {
        return this.activeTicks > 0;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, NautiliteBlockEntity be) {
        if (be.activationTime != -1L && world != null) {
            long now = world.method_8510();
            long elapsed = now - be.activationTime;
            int expected = NautiliteBlockEntity.duration() - (int)elapsed;
            if (Math.abs(be.activeTicks - expected) > 5) {
                be.activeTicks = Math.max(0, expected);
            }
        }
        if (!be.isActive()) {
            return;
        }
        --be.activeTicks;
        if (world instanceof class_3218) {
            class_3218 server = (class_3218)world;
            int r = NautiliteBlockEntity.effectRadius();
            class_238 area = new class_238(pos).method_1014((double)r);
            List players = server.method_8390(class_1657.class, area, e -> true);
            for (class_1657 p : players) {
                if (p.method_5721()) {
                    p.method_6092(new class_1293(class_1294.field_5927, 40, 0, true, false));
                }
                if (!p.method_6059(class_1294.field_5901)) continue;
                p.method_6016(class_1294.field_5901);
            }
            List mobs = server.method_8390(class_1309.class, area, e -> true);
            for (class_1309 mob : mobs) {
                if (!(mob instanceof class_1551) && !(mob instanceof class_1577) || !mob.method_5721() || !pos.method_19771((class_2382)mob.method_24515(), (double)r)) continue;
                mob.method_5643(world.method_48963().method_48831(), 2.0f);
                server.method_14199((class_2394)class_2398.field_11247, mob.method_23317(), mob.method_23318(), mob.method_23321(), 10, 0.5, 0.5, 0.5, 0.1);
            }
            NautiliteBlockEntity.emitParticles(server, pos);
        }
        if (be.activeTicks <= 0) {
            assert (world != null);
            world.method_8396(null, pos, class_3417.field_14979, class_3419.field_15245, 1.0f, 1.0f);
            world.method_8650(pos, false);
        } else {
            be.method_5431();
        }
    }

    private static void emitParticles(class_3218 world, class_2338 pos) {
        class_243 c = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        class_5819 rand = world.method_8409();
        for (int i = 0; i < 5; ++i) {
            double x = c.field_1352 + (rand.method_43058() - 0.5) * 2.0;
            double y = c.field_1351 + (rand.method_43058() - 0.5) * 2.0;
            double z = c.field_1350 + (rand.method_43058() - 0.5) * 2.0;
            world.method_14199((class_2394)class_2398.field_11247, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.activeTicks = nbt.method_10550("ActiveTicks");
        this.activationTime = nbt.method_10537("ActivationTime");
        if (this.activationTime != -1L && this.field_11863 != null && this.activeTicks > 0) {
            long now = this.field_11863.method_8510();
            long elapsed = now - this.activationTime;
            this.activeTicks = Math.max(0, NautiliteBlockEntity.duration() - (int)elapsed);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10569("ActiveTicks", this.activeTicks);
        nbt.method_10544("ActivationTime", this.activationTime);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbt = super.method_16887(registryLookup);
        nbt.method_10569("ActiveTicks", this.activeTicks);
        nbt.method_10544("ActivationTime", this.activationTime);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

