/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.Optional;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.RitualBrazierBlock;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.SyncBlockEntity;
import net.astralya.hexalia.particle.ModParticleType;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.RitualBrazierRecipeInput;
import net.astralya.hexalia.util.ModUtil;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;

public class RitualBrazierBlockEntity
extends SyncBlockEntity
implements class_1263 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private boolean isRitualFocusItem = false;
    private float rotation = 0.0f;

    public RitualBrazierBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.RITUAL_BRAZIER, pos, state);
    }

    public int method_5444() {
        return 1;
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        return ((class_1799)this.inventory.getFirst()).method_7960();
    }

    public class_1799 method_5438(int slot) {
        return slot == 0 ? (class_1799)this.inventory.getFirst() : class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this.inventory, (int)slot, (int)amount);
        if (!result.method_7960()) {
            this.inventoryChanged();
        }
        return result;
    }

    public class_1799 method_5441(int slot) {
        class_1799 result = class_1262.method_5428(this.inventory, (int)slot);
        if (!result.method_7960()) {
            this.inventoryChanged();
        }
        return result;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)(stack.method_7960() ? class_1799.field_8037 : stack.method_46651(1)));
        this.inventoryChanged();
    }

    public boolean method_5443(class_1657 player) {
        double cz;
        double cy;
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        double cx = (double)this.field_11867.method_10263() + 0.5;
        return player.method_5649(cx, cy = (double)this.field_11867.method_10264() + 0.5, cz = (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.inventory.set(0, (Object)class_1799.field_8037);
        this.isRitualFocusItem = false;
        this.inventoryChanged();
    }

    public boolean addItem(class_1799 fromPlayer) {
        if (this.method_5442() && !fromPlayer.method_7960()) {
            class_1799 one = fromPlayer.method_7971(1);
            this.inventory.set(0, (Object)(one.method_7960() ? class_1799.field_8037 : one));
            this.isRitualFocusItem = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public class_1799 removeItem() {
        if (this.method_5442()) {
            return class_1799.field_8037;
        }
        this.isRitualFocusItem = false;
        class_1799 out = (class_1799)this.inventory.getFirst();
        this.inventory.set(0, (Object)class_1799.field_8037);
        this.inventoryChanged();
        return out;
    }

    public class_1799 getStoredItem() {
        return this.method_5438(0);
    }

    public float getRenderingRotation() {
        this.rotation += 0.5f;
        if (this.rotation >= 360.0f) {
            this.rotation = 0.0f;
        }
        return this.rotation;
    }

    public RitualResult tryCelestialRitual() {
        if (this.field_11863 == null || this.isRitualFocusItem) {
            return RitualResult.INVALID_ITEM;
        }
        class_2338 bloomPos = this.findNearbyCelestialBloom();
        if (bloomPos == null) {
            return RitualResult.NO_CELESTIAL_BLOOMS;
        }
        class_1799 input = this.getStoredItem();
        if (input.method_7960()) {
            return RitualResult.INVALID_ITEM;
        }
        Optional match = this.field_11863.method_8433().method_8132(ModRecipes.RITUAL_BRAZIER_TYPE, (class_9695)new RitualBrazierRecipeInput(input), this.field_11863);
        if (match.isEmpty()) {
            return RitualResult.INVALID_ITEM;
        }
        class_8786 entry = (class_8786)match.get();
        class_1799 result = entry.comp_1933().method_8110((class_7225.class_7874)this.field_11863.method_30349());
        if (result.method_7960()) {
            return RitualResult.INVALID_ITEM;
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)RitualBrazierBlock.FACING);
        class_2350 eject = facing.method_10160();
        double ox = 0.5 + (double)eject.method_10148() * 0.2;
        double oy = 0.2;
        double oz = 0.5 + (double)eject.method_10165() * 0.2;
        float vx = (float)eject.method_10148() * 0.2f;
        float vy = 0.0f;
        float vz = (float)eject.method_10165() * 0.2f;
        class_1799 out = result.method_7972();
        if (ModUtil.hasSpawnItemEntity()) {
            ModUtil.spawnItemEntity(this.field_11863, out, (double)this.field_11867.method_10263() + ox, (double)this.field_11867.method_10264() + oy, (double)this.field_11867.method_10260() + oz, vx, vy, vz);
        } else {
            this.field_11863.method_8649((class_1297)new class_1542(this.field_11863, (double)this.field_11867.method_10263() + ox, (double)this.field_11867.method_10264() + oy, (double)this.field_11867.method_10260() + oz, out, (double)vx, (double)vy, (double)vz));
        }
        this.removeItem();
        if (!this.field_11863.field_9236) {
            this.field_11863.method_8652(bloomPos, class_2246.field_10428.method_9564(), 3);
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 server = (class_3218)class_19372;
                this.emitEffects(server, bloomPos);
            }
        }
        return RitualResult.SUCCESS;
    }

    private class_2338 findNearbyCelestialBloom() {
        if (this.field_11863 == null) {
            return null;
        }
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                class_2338 check;
                if (dx == 0 && dz == 0 || !this.field_11863.method_8320(check = this.field_11867.method_10069(dx, 0, dz)).method_27852(ModBlocks.CELESTIAL_BLOOM)) continue;
                return check;
            }
        }
        return null;
    }

    private void emitEffects(class_3218 server, class_2338 at) {
        server.method_14199((class_2394)ModParticleType.LEAVES, (double)at.method_10263() + 0.5, (double)at.method_10264() + 0.6, (double)at.method_10260() + 0.5, 15, 0.2, 0.25, 0.2, 0.0);
    }

    public void playSound(class_3414 sound, float volume, float pitch) {
        if (this.field_11863 != null) {
            this.field_11863.method_8396(null, this.field_11867, sound, class_3419.field_15245, volume, pitch);
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10556("IsItemImbued", this.isRitualFocusItem);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.isRitualFocusItem = nbt.method_10577("IsItemImbued");
        this.inventory.set(0, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    public static enum RitualResult {
        SUCCESS,
        NO_CELESTIAL_BLOOMS,
        INVALID_ITEM;

    }
}

