/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.util;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;

public class TeleportUtil {
    public static boolean canReturn(class_1937 world, class_1657 player, boolean allowInterdimensional) {
        if (world.field_9236) {
            return false;
        }
        if (!(player instanceof class_3222)) {
            return false;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_5321 spawnDim = serverPlayer.method_26281();
        return !allowInterdimensional && world.method_27983() != spawnDim;
    }

    public static void teleportPlayerToSpawn(class_1937 currentWorld, class_1657 player, boolean allowInterdimensional) {
        if (currentWorld.field_9236 || TeleportUtil.canReturn(currentWorld, player, allowInterdimensional)) {
            return;
        }
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        class_3218 targetWorld = TeleportUtil.getTargetWorld(currentWorld, serverPlayer);
        player.method_5848();
        if (player.method_6113()) {
            player.method_18400();
        }
        if (targetWorld != null) {
            Optional<class_243> pos;
            class_2338 spawnPoint = TeleportUtil.getSpawnPointPosition(serverPlayer, targetWorld);
            if (spawnPoint != null && (pos = TeleportUtil.findRespawnPosition(targetWorld, spawnPoint)).isPresent()) {
                TeleportUtil.doReturn(serverPlayer, currentWorld, targetWorld, pos.get().field_1352, pos.get().field_1351, pos.get().field_1350);
                return;
            }
            class_2338 fallback = targetWorld.method_43126();
            TeleportUtil.doReturn(serverPlayer, currentWorld, targetWorld, (double)fallback.method_10263() + 0.5, fallback.method_10264(), (double)fallback.method_10260() + 0.5);
        }
    }

    private static class_3218 getTargetWorld(class_1937 currentWorld, class_3222 player) {
        class_5321 spawnDim = player.method_26281();
        return currentWorld.method_27983() == spawnDim ? (class_3218)currentWorld : Objects.requireNonNull(currentWorld.method_8503()).method_3847(spawnDim);
    }

    private static class_2338 getSpawnPointPosition(class_3222 player, class_3218 world) {
        return player.method_26280();
    }

    private static Optional<class_243> findRespawnPosition(class_3218 world, class_2338 spawnPoint) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int yOffset = 0; yOffset <= 2; ++yOffset) {
            boolean hasSpace;
            mutable.method_10103(spawnPoint.method_10263(), spawnPoint.method_10264() + yOffset, spawnPoint.method_10260());
            boolean bl = hasSpace = world.method_8320((class_2338)mutable).method_26220((class_1922)world, (class_2338)mutable).method_1110() && world.method_8320(mutable.method_10084()).method_26220((class_1922)world, mutable.method_10084()).method_1110();
            if (!hasSpace) continue;
            return Optional.of(new class_243((double)mutable.method_10263() + 0.5, (double)mutable.method_10264(), (double)mutable.method_10260() + 0.5));
        }
        return Optional.empty();
    }

    private static void doReturn(class_3222 player, class_1937 origin, class_3218 target, double x, double y, double z) {
        TeleportUtil.playTeleportSound((class_1657)player, target, x, y, z);
        if (origin != target) {
            player.method_14251(target, x, y, z, player.method_36454(), player.method_36455());
        } else {
            player.method_5859(x, y, z);
        }
        if (player.field_6017 > 0.0f) {
            player.field_6017 = 0.0f;
        }
        TeleportUtil.playTeleportSound((class_1657)player, target, x, y, z);
    }

    private static void playTeleportSound(class_1657 player, class_3218 world, double x, double y, double z) {
        world.method_43128(null, x, y, z, class_3417.field_14890, class_3419.field_15248, 1.0f, 1.0f);
    }
}

