/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import java.util.List;
import net.astralya.hexalia.Configuration;
import net.astralya.hexalia.block.custom.WallMountedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DreamcatcherBlock
extends WallMountedBlock {
    public DreamcatcherBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int range = (Integer)Configuration.DREAMCATCHER_RADIUS.get();
        int igniteTime = (Integer)Configuration.PHANTOM_IGNITE_DURATION.get();
        AABB checkArea = new AABB(Vec3.atCenterOf((Vec3i)pos.offset(-range, -range, -range)), Vec3.atCenterOf((Vec3i)pos.offset(range, range, range)));
        List phantoms = level.getEntitiesOfClass(Phantom.class, checkArea);
        for (Phantom phantom : phantoms) {
            phantom.igniteForTicks(igniteTime);
        }
        level.scheduleTick(pos, (Block)this, 20);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide) {
            level.scheduleTick(pos, (Block)this, 20);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.onRemove(state, level, pos, newState, movedByPiston);
    }
}

