/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import java.util.concurrent.ThreadLocalRandom;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.particle.ModParticleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class InfusedDirtBlock
extends Block {
    public InfusedDirtBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof HoeItem && state.is((Block)ModBlocks.INFUSED_DIRT.get()) && hitResult.getDirection() != Direction.DOWN && level.isEmptyBlock(pos.above())) {
            if (!level.isClientSide) {
                level.playSound(null, pos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlock(pos, ((Block)ModBlocks.INFUSED_FARMLAND.get()).defaultBlockState(), 3);
                if (!player.isCreative()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        this.spawnBubblesParticles(level, pos);
    }

    private void spawnBubblesParticles(Level level, BlockPos pos) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 8; ++i) {
            double x = (double)pos.getX() + 0.5 + random.nextDouble(-0.5, 0.5);
            double y = (double)pos.getY() + 1.0;
            double z = (double)pos.getZ() + 0.5 + random.nextDouble(-0.5, 0.5);
            level.addParticle((ParticleOptions)ModParticleType.INFUSED_BUBBLES.get(), x, y, z, 0.0, 0.05, 0.0);
        }
    }
}

