/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.astralya.hexalia.block.custom.RitualBrazierBlock;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.RitualBrazierBlockEntity;
import net.astralya.hexalia.block.entity.custom.RitualTableBlockEntity;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.RitualTableRecipe;
import net.astralya.hexalia.recipe.RitualTableRecipeInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RitualTableBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.125, (double)0.8125), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.25, (double)0.125, (double)0.25, (double)0.75, (double)0.625, (double)0.75), Shapes.box((double)0.1875, (double)0.625, (double)0.1875, (double)0.8125, (double)0.6875, (double)0.8125), Shapes.box((double)0.125, (double)0.6875, (double)0.125, (double)0.875, (double)0.8125, (double)0.875)});
    public static final MapCodec<RitualTableBlock> CODEC = RitualTableBlock.simpleCodec(RitualTableBlock::new);

    public RitualTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> b) {
        b.add(new Property[]{FACING});
    }

    protected VoxelShape getShape(BlockState s, BlockGetter l, BlockPos p, CollisionContext c) {
        return SHAPE;
    }

    protected RenderShape getRenderShape(BlockState s) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RitualTableBlockEntity(pos, state);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof RitualTableBlockEntity) {
            RitualTableBlockEntity tableBE = (RitualTableBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)tableBE);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, moved);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof RitualTableBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        RitualTableBlockEntity tableBE = (RitualTableBlockEntity)blockEntity;
        if (stack.is(ModItems.HEX_FOCUS) && this.tryStartRitual(level, pos, player, tableBE)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (tableBE.isEmpty() && !stack.isEmpty() && !stack.is(ModItems.HEX_FOCUS)) {
            this.addItemToBlock(stack, level, pos, player, tableBE);
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.isEmpty() && !tableBE.getItem(0).isEmpty()) {
            this.removeItemFromBlock(level, pos, player, tableBE);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private boolean tryStartRitual(Level level, BlockPos pos, Player player, RitualTableBlockEntity tableBE) {
        ItemStack tableItem = tableBE.getItem(0);
        if (tableItem.isEmpty()) {
            this.fail(level, pos, player, "message.hexalia.ritual.missing_ingredients");
            return true;
        }
        BlockPos[] offsets = new BlockPos[]{pos.north(2), pos.south(2), pos.east(2), pos.west(2)};
        ArrayList<RitualBrazierBlockEntity> filled = new ArrayList<RitualBrazierBlockEntity>();
        for (BlockPos bp : offsets) {
            RitualBrazierBlockEntity b;
            BlockEntity blockEntity = level.getBlockEntity(bp);
            if (!(blockEntity instanceof RitualBrazierBlockEntity) || (b = (RitualBrazierBlockEntity)blockEntity).getStoredItem().isEmpty()) continue;
            filled.add(b);
        }
        Match match = this.findMatch(level, tableItem, filled, tableBE);
        if (match == null) {
            this.fail(level, pos, player, "message.hexalia.ritual.wrong_recipe");
            return true;
        }
        for (RitualBrazierBlockEntity b : match.usedBraziers) {
            BlockState bs = level.getBlockState(b.getBlockPos());
            if (bs.hasProperty((Property)RitualBrazierBlock.SALTED) && ((Boolean)bs.getValue((Property)RitualBrazierBlock.SALTED)).booleanValue()) continue;
            this.fail(level, pos, player, "message.hexalia.ritual.missing_salt");
            return true;
        }
        List<BlockPos> grownCrops = this.findFullyGrownCrops(level, pos, 8, 8);
        if (grownCrops.size() < 8) {
            this.fail(level, pos, player, "message.hexalia.ritual.invalid_crops");
            return true;
        }
        int duration = match.usedBraziers.size() * 40;
        tableBE.startTransformation(match.recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).copy(), duration, match.usedBraziers);
        tableBE.setGrownCropPositions(grownCrops);
        this.play(level, pos);
        this.puff(level, pos, ParticleTypes.POOF, 5, 10);
        return true;
    }

    @Nullable
    private Match findMatch(Level level, ItemStack tableItem, List<RitualBrazierBlockEntity> available, RitualTableBlockEntity tableBE) {
        RitualTableRecipeInput input = new RitualTableRecipeInput(tableBE);
        List candidates = level.getRecipeManager().getRecipesFor((RecipeType)ModRecipes.RITUAL_TABLE_TYPE.get(), (RecipeInput)input, level);
        for (RecipeHolder holder : candidates) {
            RitualTableRecipe r = (RitualTableRecipe)holder.value();
            NonNullList<Ingredient> ings = r.getIngredients();
            if (ings.isEmpty() || !((Ingredient)ings.get(0)).test(tableItem)) continue;
            ArrayList<RitualBrazierBlockEntity> pool = new ArrayList<RitualBrazierBlockEntity>(available);
            ArrayList<RitualBrazierBlockEntity> used = new ArrayList<RitualBrazierBlockEntity>();
            boolean ok = true;
            for (Ingredient need : ings.subList(1, ings.size())) {
                int idx = -1;
                for (int i = 0; i < pool.size(); ++i) {
                    if (!need.test(((RitualBrazierBlockEntity)((Object)pool.get(i))).getStoredItem())) continue;
                    idx = i;
                    break;
                }
                if (idx == -1) {
                    ok = false;
                    break;
                }
                used.add((RitualBrazierBlockEntity)((Object)pool.remove(idx)));
            }
            if (!ok) continue;
            return new Match(r, used);
        }
        return null;
    }

    private List<BlockPos> findFullyGrownCrops(Level level, BlockPos center, int required, int radius) {
        ArrayList<BlockPos> found = new ArrayList<BlockPos>();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                CropBlock crop;
                BlockPos p = center.offset(dx, 0, dz);
                BlockState s = level.getBlockState(p);
                Block block = s.getBlock();
                if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).isMaxAge(s)) continue;
                found.add(p);
                if (found.size() < required) continue;
                return found;
            }
        }
        return found;
    }

    private void addItemToBlock(ItemStack stack, Level level, BlockPos pos, Player player, RitualTableBlockEntity be) {
        be.setItem(0, stack);
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        this.play(level, pos);
    }

    private void removeItemFromBlock(Level level, BlockPos pos, Player player, RitualTableBlockEntity be) {
        ItemStack onTable = be.getItem(0);
        if (!player.getAbilities().instabuild) {
            player.setItemInHand(InteractionHand.MAIN_HAND, onTable);
        }
        be.clearContent();
        this.play(level, pos);
    }

    private void fail(Level level, BlockPos pos, Player player, String key) {
        this.puff(level, pos, ParticleTypes.SMOKE, 8, 12);
        if (!level.isClientSide) {
            player.displayClientMessage((Component)Component.translatable((String)key), true);
        }
        level.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 0.4f, 0.6f);
    }

    private void puff(Level level, BlockPos pos, SimpleParticleType type, int min, int max) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int count = ThreadLocalRandom.current().nextInt(min, max);
            for (int i = 0; i < count; ++i) {
                double x = (double)pos.getX() + 0.5 + ThreadLocalRandom.current().nextDouble(-0.5, 0.5);
                double y = (double)pos.getY() + 1.0 + ThreadLocalRandom.current().nextDouble(0.0, 0.5);
                double z = (double)pos.getZ() + 0.5 + ThreadLocalRandom.current().nextDouble(-0.5, 0.5);
                server.sendParticles((ParticleOptions)type, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void play(Level level, BlockPos pos) {
        level.playSound(null, pos, SoundEvents.CHISELED_BOOKSHELF_PICKUP_ENCHANTED, SoundSource.BLOCKS, 0.8f, 0.5f);
        level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.8f, 0.5f);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide && type == ModBlockEntityTypes.RITUAL_TABLE.get() ? (lvl, p, st, be) -> RitualTableBlockEntity.serverTick(lvl, p, st, (RitualTableBlockEntity)be) : null;
    }

    private static final class Match {
        final RitualTableRecipe recipe;
        final List<RitualBrazierBlockEntity> usedBraziers;

        Match(RitualTableRecipe r, List<RitualBrazierBlockEntity> u) {
            this.recipe = r;
            this.usedBraziers = u;
        }
    }
}

