/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.astralya.hexalia.block.entity.custom.ShelfBlockEntity;
import net.astralya.hexalia.util.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final Map<Direction, VoxelShape> SHAPES = ShelfBlock.createShapes();
    public static final MapCodec<ShelfBlock> CODEC = ShelfBlock.simpleCodec(ShelfBlock::new);

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ShelfBlockEntity) {
            double relativeZ;
            double relativeX;
            ShelfBlockEntity shelf = (ShelfBlockEntity)blockEntity;
            Vec3 hitPos = hitResult.getLocation();
            Direction facing = (Direction)state.getValue((Property)FACING);
            double x = hitPos.x() - (double)pos.getX();
            double y = hitPos.y() - (double)pos.getY();
            double z = hitPos.z() - (double)pos.getZ();
            switch (facing) {
                case NORTH: {
                    relativeX = 1.0 - x;
                    relativeZ = z;
                    break;
                }
                case SOUTH: {
                    relativeX = x;
                    relativeZ = 1.0 - z;
                    break;
                }
                case EAST: {
                    relativeX = 1.0 - z;
                    relativeZ = 1.0 - x;
                    break;
                }
                case WEST: {
                    relativeX = z;
                    relativeZ = x;
                    break;
                }
                default: {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
            }
            if (relativeZ < 0.5 || relativeZ > 1.0 || y < 0.25 || y > 0.75) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            int row = relativeZ < 0.75 ? 1 : 0;
            int column = relativeX < 0.33 ? 0 : (relativeX < 0.67 ? 1 : 2);
            int slot = column + row * 3;
            ItemStack heldItem = player.getItemInHand(hand);
            ItemStack shelfItem = shelf.getItem(slot);
            if (!shelfItem.isEmpty()) {
                ItemStack removedItem = shelf.removeStack(slot);
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.getInventory().add(removedItem)) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)removedItem);
                }
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            if (this.isValidItem(heldItem)) {
                ItemStack toPlace;
                if (player.isCreative()) {
                    toPlace = heldItem.copy();
                    toPlace.setCount(1);
                } else {
                    toPlace = heldItem.split(1);
                }
                shelf.setItem(slot, toPlace);
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private boolean isValidItem(ItemStack stack) {
        return !stack.isEmpty() && stack.is(ModTags.Items.BREWS) || stack.is(Items.POTION) || stack.is(Items.LINGERING_POTION) || stack.is(Items.SPLASH_POTION);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockPos supportPos = pos.relative(direction);
        BlockState supportState = level.getBlockState(supportPos);
        return supportState.isFaceSturdy((BlockGetter)level, supportPos, direction.getOpposite());
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ShelfBlockEntity) {
                ShelfBlockEntity shelf = (ShelfBlockEntity)blockEntity;
                if (level instanceof ServerLevel) {
                    for (int i = 0; i < 6; ++i) {
                        ItemStack stack = shelf.getItem(i);
                        if (stack.isEmpty()) continue;
                        Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
                    }
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexalia.shelf").withStyle(ChatFormatting.GRAY));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ShelfBlockEntity(blockPos, blockState);
    }

    private static VoxelShape createShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.5, (double)1.0, (double)0.3125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private static Map<Direction, VoxelShape> createShapes() {
        HashMap<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>();
        VoxelShape baseShape = ShelfBlock.createShape();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            shapes.put(direction, ShelfBlock.rotateShape(Direction.NORTH, direction, baseShape));
        }
        return shapes;
    }

    private static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }
}

