/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.Optional;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.block.custom.RitualBrazierBlock;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.SyncBlockEntity;
import net.astralya.hexalia.particle.ModParticleType;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.RitualBrazierRecipe;
import net.astralya.hexalia.recipe.RitualBrazierRecipeInput;
import net.astralya.hexalia.util.ModUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

@EventBusSubscriber(modid="hexalia", bus=EventBusSubscriber.Bus.MOD)
public class RitualBrazierBlockEntity
extends SyncBlockEntity {
    private final ItemStackHandler inventory = this.createHandler();
    private final RecipeManager.CachedCheck<RitualBrazierRecipeInput, RitualBrazierRecipe> quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)ModRecipes.RITUAL_BRAZIER_TYPE.get()));
    private boolean isRitualFocusItem = false;
    private float rotation;

    public RitualBrazierBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.RITUAL_BRAZIER.get(), pos, state);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                RitualBrazierBlockEntity.this.inventoryChanged();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    public RitualResult tryCelestialRitual() {
        if (this.level == null || this.isRitualFocusItem) {
            return RitualResult.INVALID_ITEM;
        }
        BlockPos bloomPos = this.findNearbyCelestialBloom();
        if (bloomPos == null) {
            return RitualResult.NO_CELESTIAL_BLOOMS;
        }
        Optional match = this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.RITUAL_BRAZIER_TYPE.get(), (RecipeInput)new RitualBrazierRecipeInput(this.getStoredItem()), this.level);
        if (match.isEmpty()) {
            return RitualResult.INVALID_ITEM;
        }
        ItemStack resultStack = ((RitualBrazierRecipe)((RecipeHolder)match.get()).value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
        Direction eject = ((Direction)this.getBlockState().getValue((Property)RitualBrazierBlock.FACING)).getCounterClockWise();
        ModUtil.spawnItemEntity(this.level, resultStack.copy(), (double)this.worldPosition.getX() + 0.5 + (double)eject.getStepX() * 0.2, (double)this.worldPosition.getY() + 0.2, (double)this.worldPosition.getZ() + 0.5 + (double)eject.getStepZ() * 0.2, (float)eject.getStepX() * 0.2f, 0.0, (float)eject.getStepZ() * 0.2f);
        this.removeItem();
        if (!this.level.isClientSide) {
            this.level.setBlock(bloomPos, Blocks.DEAD_BUSH.defaultBlockState(), 3);
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                this.emitEffects(server, bloomPos);
            }
        }
        return RitualResult.SUCCESS;
    }

    private BlockPos findNearbyCelestialBloom() {
        if (this.level == null) {
            return null;
        }
        BlockPos origin = this.getBlockPos();
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                BlockPos check;
                if (dx == 0 && dz == 0 || !this.level.getBlockState(check = origin.offset(dx, 0, dz)).is((Block)ModBlocks.CELESTIAL_BLOOM.get())) continue;
                return check;
            }
        }
        return null;
    }

    private void emitEffects(ServerLevel server, BlockPos at) {
        server.playSound(null, at, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 0.5f, 1.0f);
        server.sendParticles((ParticleOptions)ModParticleType.LEAVES.get(), (double)at.getX() + 0.5, (double)at.getY() + 0.6, (double)at.getZ() + 0.5, 15, 0.2, 0.25, 0.2, 0.0);
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.level != null) {
            this.level.playSound(null, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.5f), (double)((float)this.worldPosition.getZ() + 0.5f), sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    public boolean addItem(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.isEmpty()) {
            this.inventory.setStackInSlot(0, itemStack.split(1));
            this.isRitualFocusItem = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            this.isRitualFocusItem = false;
            ItemStack item = this.getStoredItem().split(1);
            this.inventoryChanged();
            return item;
        }
        return ItemStack.EMPTY;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public ItemStack getStoredItem() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean isEmpty() {
        return this.inventory.getStackInSlot(0).isEmpty();
    }

    public float getRenderingRotation() {
        this.rotation += 0.5f;
        if (this.rotation >= 360.0f) {
            this.rotation = 0.0f;
        }
        return this.rotation;
    }

    public void setRemoved() {
        super.setRemoved();
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("IsItemImbued", this.isRitualFocusItem);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(provider));
        return tag;
    }

    @Override
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.isRitualFocusItem = tag.getBoolean("IsItemImbued");
        this.inventory.deserializeNBT(provider, tag.getCompound("Inventory"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean("IsItemImbued", this.isRitualFocusItem);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(provider));
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.RITUAL_BRAZIER.get(), (be, ctx) -> be.getInventory());
    }

    public static enum RitualResult {
        SUCCESS,
        NO_CELESTIAL_BLOOMS,
        INVALID_ITEM;

    }
}

