/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.block.entity.custom;

import java.util.Optional;
import net.astralya.hexalia.block.entity.ModBlockEntityTypes;
import net.astralya.hexalia.block.entity.custom.HeatingBlock;
import net.astralya.hexalia.block.entity.custom.SyncBlockEntity;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.SmallCauldronRecipe;
import net.astralya.hexalia.screen.custom.SmallCauldronMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;

public class SmallCauldronBlockEntity
extends SyncBlockEntity
implements MenuProvider,
HeatingBlock {
    public final ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            SmallCauldronBlockEntity.this.setChanged();
            if (!SmallCauldronBlockEntity.this.level.isClientSide()) {
                SmallCauldronBlockEntity.this.level.sendBlockUpdated(SmallCauldronBlockEntity.this.getBlockPos(), SmallCauldronBlockEntity.this.getBlockState(), SmallCauldronBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private static final int INPUT_SLOT_1 = 0;
    private static final int INPUT_SLOT_2 = 1;
    private static final int INPUT_SLOT_3 = 2;
    private static final int OUTPUT_SLOT = 3;
    private static final int BOTTLE_SLOT = 4;
    private final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> SmallCauldronBlockEntity.this.progress;
                case 1 -> SmallCauldronBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    SmallCauldronBlockEntity.this.progress = value;
                }
                case 1: {
                    SmallCauldronBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 175;
    private final int DEFAULT_MAX_PROGRESS = 175;
    @Nullable
    private Player lastInteractedPlayer;

    public SmallCauldronBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntityTypes.SMALL_CAULDRON.get(), pos, blockState);
    }

    public void clearContents() {
        this.inventory.setStackInSlot(0, ItemStack.EMPTY);
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.hasRecipe() && this.isOutputSlotEmptyOrReceivable() && this.isHeated()) {
            this.increaseCraftingProgress();
            SmallCauldronBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 175;
    }

    private void craftItem() {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)this.inventory);
        Optional match = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.SMALL_CAULDRON_TYPE.get(), (RecipeInput)wrapper, level);
        if (match.isPresent()) {
            SmallCauldronRecipe recipe = (SmallCauldronRecipe)((RecipeHolder)match.get()).value();
            ItemStack result = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
            ItemStack currentOutput = this.inventory.getStackInSlot(3);
            this.inventory.setStackInSlot(3, new ItemStack((ItemLike)result.getItem(), currentOutput.getCount() + result.getCount()));
            for (int i = 0; i < 3; ++i) {
                this.inventory.extractItem(i, 1, false);
            }
            if (!recipe.getBottleSlot().isEmpty()) {
                this.inventory.extractItem(4, 1, false);
            }
            if (this.lastInteractedPlayer != null) {
                this.grantExperience(this.lastInteractedPlayer, recipe.getExperience());
            }
            SmallCauldronBlockEntity.setChanged((Level)level, (BlockPos)this.worldPosition, (BlockState)this.getBlockState());
        }
    }

    private void grantExperience(Player player, float experience) {
        if (experience > 0.0f && !player.level().isClientSide) {
            player.giveExperiencePoints((int)experience);
        }
    }

    public void setLastInteractedPlayer(Player player) {
        this.lastInteractedPlayer = player;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean isOutputSlotEmptyOrReceivable() {
        return this.inventory.getStackInSlot(3).isEmpty() || this.inventory.getStackInSlot(3).getCount() < this.inventory.getStackInSlot(3).getMaxStackSize();
    }

    private boolean hasRecipe() {
        Level level = this.getLevel();
        if (level == null) {
            return false;
        }
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)this.inventory);
        Optional match = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.SMALL_CAULDRON_TYPE.get(), (RecipeInput)wrapper, level);
        if (match.isEmpty()) {
            return false;
        }
        SmallCauldronRecipe recipe = (SmallCauldronRecipe)((RecipeHolder)match.get()).value();
        ItemStack result = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        this.maxProgress = recipe.getBrewTime();
        return this.canInsertAmountIntoOutputSlot(result.getCount()) && this.canInsertItemIntoOutputSlot(result);
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.inventory.getStackInSlot(3).isEmpty() || this.inventory.getStackInSlot(3).getItem() == output.getItem();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.inventory.getStackInSlot(3).isEmpty() ? 64 : this.inventory.getStackInSlot(3).getMaxStackSize();
        int currentCount = this.inventory.getStackInSlot(3).getCount();
        return maxCount >= currentCount + count;
    }

    public boolean isHeated() {
        return this.level != null && this.isHeated(this.level, this.worldPosition);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.hexalia.small_cauldron");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new SmallCauldronMenu(i, inventory, this, this.data);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("small_cauldron.progress", this.progress);
        tag.putInt("small_cauldron.max_progress", this.maxProgress);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.progress = tag.getInt("small_cauldron.progress");
        this.maxProgress = tag.getInt("small_cauldron.max_progress");
    }

    @Override
    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

