/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.compat.jei;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.compat.jei.category.MutationRecipeCategory;
import net.astralya.hexalia.compat.jei.category.RitualBrazierRecipeCategory;
import net.astralya.hexalia.compat.jei.category.RitualTableRecipeCategory;
import net.astralya.hexalia.compat.jei.category.SmallCauldronRecipeCategory;
import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.MutationRecipe;
import net.astralya.hexalia.recipe.RitualBrazierRecipe;
import net.astralya.hexalia.recipe.RitualTableRecipe;
import net.astralya.hexalia.recipe.SmallCauldronRecipe;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SmallCauldronRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RitualBrazierRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RitualTableRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MutationRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SMALL_CAULDRON.get()), new RecipeType[]{SmallCauldronRecipeCategory.SMALL_CAULDRON_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.RITUAL_BRAZIER.get()), new RecipeType[]{RitualBrazierRecipeCategory.RITUAL_BRAZIER_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.RITUAL_TABLE.get()), new RecipeType[]{RitualTableRecipeCategory.RITUAL_TABLE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.MUTAVIS.get()), new RecipeType[]{MutationRecipeCategory.MUTATION_RECIPE_RECIPE_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List<SmallCauldronRecipe> smallCauldronRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.SMALL_CAULDRON_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(SmallCauldronRecipeCategory.SMALL_CAULDRON_RECIPE_TYPE, smallCauldronRecipes);
        List<RitualBrazierRecipe> ritualBrazierRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.RITUAL_BRAZIER_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(RitualBrazierRecipeCategory.RITUAL_BRAZIER_RECIPE_TYPE, ritualBrazierRecipes);
        List<RitualTableRecipe> ritualTableRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.RITUAL_TABLE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(RitualTableRecipeCategory.RITUAL_TABLE_RECIPE_TYPE, ritualTableRecipes);
        List<MutationRecipe> mutationRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.MUTATION_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(MutationRecipeCategory.MUTATION_RECIPE_RECIPE_TYPE, mutationRecipes);
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModBlocks.WILD_SUNFIRE_TOMATO.get()), new ItemStack((ItemLike)ModItems.SUNFIRE_TOMATO.get()), new ItemStack((ItemLike)ModItems.SUNFIRE_TOMATO_SEEDS.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.info.wild_sunfire_tomatoes")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModBlocks.WILD_MANDRAKE.get()), new ItemStack((ItemLike)ModItems.MANDRAKE.get()), new ItemStack((ItemLike)ModItems.MANDRAKE_SEEDS.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.info.wild_mandrakes")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModBlocks.CHILLBERRY_BUSH.get()), new ItemStack((ItemLike)ModItems.CHILLBERRIES.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.info.chillberry_bushes")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModItems.SALTSPROUT.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"jei.info.saltsprout")});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        super.registerGuiHandlers(registration);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

