/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.compat.jei.category;

import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.recipe.RitualBrazierRecipe;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RitualBrazierRecipeCategory
implements IRecipeCategory<RitualBrazierRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"ritual_brazier");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hexalia", (String)"textures/gui/ritual_brazier_gui.png");
    public static final RecipeType<RitualBrazierRecipe> RITUAL_BRAZIER_RECIPE_TYPE = new RecipeType(UID, RitualBrazierRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable hexIcon;
    private static final int WIDTH = 118;
    private static final int HEIGHT = 80;

    public RitualBrazierRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 118, 80);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.RITUAL_BRAZIER.get()));
        this.hexIcon = helper.createDrawable(TEXTURE, 0, 0, 16, 16);
    }

    public RecipeType<RitualBrazierRecipe> getRecipeType() {
        return RITUAL_BRAZIER_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.hexalia.ritual_brazier");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 118;
    }

    public int getHeight() {
        return 80;
    }

    public void draw(RitualBrazierRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
        this.hexIcon.draw(guiGraphics, 28, 7);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RitualBrazierRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 28, 31).addIngredients((Ingredient)recipe.getIngredients().getFirst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 89, 31).addItemStack(recipe.getResultItem(null));
    }

    public void getTooltip(ITooltipBuilder tooltip, RitualBrazierRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 4.0 && mouseX < 20.0 && mouseY >= 55.0 && mouseY < 71.0) {
            tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexalia.hex_focus_gui"));
        }
    }
}

