/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.astralya.hexalia.datagen.DataMapGenerator;
import net.astralya.hexalia.datagen.ModAdvancementsProvider;
import net.astralya.hexalia.datagen.ModBiomeTagsProvider;
import net.astralya.hexalia.datagen.ModBlockStateProvider;
import net.astralya.hexalia.datagen.ModBlockTagProvider;
import net.astralya.hexalia.datagen.ModItemModelProvider;
import net.astralya.hexalia.datagen.ModItemTagProvider;
import net.astralya.hexalia.datagen.ModRecipeProvider;
import net.astralya.hexalia.datagen.ModWorldGenProvider;
import net.astralya.hexalia.datagen.loot.GlobalLootModifier;
import net.astralya.hexalia.datagen.loot.ModBlockLootTableProvider;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="hexalia", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        net.minecraft.data.DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ModBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        ModBlockTagProvider blockTagsProvider = new ModBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new GlobalLootModifier(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DataMapGenerator(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModWorldGenProvider(packOutput, lookupProvider));
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new ModBiomeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(packOutput, lookupProvider, List.of(new ModAdvancementsProvider())));
    }
}

