/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.datagen.custom;

import java.util.LinkedHashMap;
import java.util.Map;
import net.astralya.hexalia.recipe.SmallCauldronRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class SmallCauldronRecipeBuilder
implements RecipeBuilder {
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;
    private final Item result;
    private Ingredient bottleSlot = Ingredient.EMPTY;
    private float experience = 0.0f;
    private int brewTime = 200;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public SmallCauldronRecipeBuilder(ItemStack output) {
        this.ingredients = NonNullList.create();
        this.output = output;
        this.result = output.getItem();
    }

    public static SmallCauldronRecipeBuilder smallCauldronRecipe(ItemStack output) {
        return new SmallCauldronRecipeBuilder(output);
    }

    public SmallCauldronRecipeBuilder addIngredient(Ingredient ingredient) {
        this.ingredients.add((Object)ingredient);
        return this;
    }

    public SmallCauldronRecipeBuilder addIngredient(Item item) {
        return this.addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public SmallCauldronRecipeBuilder addIngredient(ItemStack itemStack) {
        return this.addIngredient(Ingredient.of((ItemStack[])new ItemStack[]{itemStack}));
    }

    public SmallCauldronRecipeBuilder bottleSlot(Ingredient bottleSlot) {
        this.bottleSlot = bottleSlot;
        return this;
    }

    public SmallCauldronRecipeBuilder bottleSlot(Item item) {
        return this.bottleSlot(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public SmallCauldronRecipeBuilder experience(float experience) {
        this.experience = experience;
        return this;
    }

    public SmallCauldronRecipeBuilder brewTime(int brewTime) {
        this.brewTime = brewTime;
        return this;
    }

    public SmallCauldronRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String s) {
        return this;
    }

    public SmallCauldronRecipeBuilder unlockedByItem(String name, Item item) {
        return this.unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{item}));
    }

    public SmallCauldronRecipeBuilder unlockedByItems(String name, Item ... items) {
        return this.unlockedBy(name, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items));
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput output, ResourceLocation id) {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("No ingredients defined for Small Cauldron recipe");
        }
        if (this.ingredients.size() > 3) {
            throw new IllegalStateException("Too many ingredients for Small Cauldron recipe (max 3)");
        }
        Advancement.Builder advancementBuilder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        SmallCauldronRecipe recipe = new SmallCauldronRecipe(this.ingredients, this.bottleSlot, this.output, this.experience, this.brewTime);
        output.accept(id, (Recipe)recipe, advancementBuilder.build(id.withPrefix("recipes/small_cauldron/")));
    }
}

