/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.effect.cloud;

import java.util.List;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.FastColor;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class FoulCloud
extends AreaEffectCloud {
    private static final float DAMAGE_PER_SECOND = 0.5f;
    private int tickCounter = 0;

    public FoulCloud(Level level, double x, double y, double z, int durationSeconds) {
        super(level, x, y, z);
        this.setWaitTime(0);
        this.setRadius(3.0f);
        int totalTicks = Math.max(1, durationSeconds) * 20;
        this.setDuration(totalTicks);
        float radiusPerTick = -this.getRadius() / (float)totalTicks;
        this.setRadiusPerTick(radiusPerTick);
        int rgb = 6987323;
        int argb = FastColor.ARGB32.opaque((int)rgb);
        this.setParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)argb));
        this.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 2, false, true));
        this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 1, false, true));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= 20) {
            this.tickCounter = 0;
            this.pulseDamage();
        }
    }

    private void pulseDamage() {
        float r = this.getRadius();
        if (r <= 0.0f) {
            return;
        }
        List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox());
        for (LivingEntity target : list) {
            double dz;
            double dx;
            if (!target.isAlive() || !target.isAffectedByPotions() || !((dx = target.getX() - this.getX()) * dx + (dz = target.getZ() - this.getZ()) * dz <= (double)(r * r))) continue;
            LivingEntity owner = this.getOwner();
            if (owner != null) {
                target.hurt(this.damageSources().indirectMagic((Entity)this, (Entity)owner), 0.5f);
                continue;
            }
            target.hurt(this.damageSources().magic(), 0.5f);
        }
    }

    public void setCloudOwner(LivingEntity owner) {
        this.setOwner(owner);
    }
}

