/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.effect.custom;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class SlimewalkerEffect
extends MobEffect {
    public SlimewalkerEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (livingEntity.onGround() && livingEntity.isSuppressingBounce()) {
            Vec3 movement = livingEntity.getDeltaMovement();
            livingEntity.setDeltaMovement(movement.x, 1.0, movement.z);
            livingEntity.hasImpulse = true;
            livingEntity.playSound(SoundEvents.SLIME_JUMP, 1.0f, 1.0f);
            for (int i = 0; i < 8; ++i) {
                float a = livingEntity.level().random.nextFloat() * ((float)Math.PI * 2);
                float a1 = livingEntity.level().random.nextFloat() * 0.5f + 0.5f;
                float a2 = Mth.sin((float)a) * 0.5f * a1;
                float a3 = Mth.cos((float)a) * 0.5f * a1;
                livingEntity.level().addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, livingEntity.getX() + (double)a2, livingEntity.getY(), livingEntity.getZ() + (double)a3, 0.0, 0.0, 0.0);
            }
            return true;
        }
        livingEntity.fallDistance = 0.0f;
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

