/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.entity.ai.silkmoth;

import java.util.EnumSet;
import net.astralya.hexalia.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class AttractedToLightGoal
extends Goal {
    private final Mob entity;
    private final double speed;
    private BlockPos targetPos;

    public AttractedToLightGoal(Mob entity, double speed) {
        this.entity = entity;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.findAttractingLightSource();
    }

    public void start() {
        if (this.targetPos != null) {
            this.entity.getNavigation().moveTo((double)this.targetPos.getX(), (double)this.targetPos.getY(), (double)this.targetPos.getZ(), this.speed);
        }
    }

    public boolean canContinueToUse() {
        if (this.entity.onGround() && this.isNearLightSource()) {
            this.entity.getNavigation().stop();
            return true;
        }
        return this.targetPos != null && !this.entity.getNavigation().isDone();
    }

    public void stop() {
        this.targetPos = null;
    }

    private boolean findAttractingLightSource() {
        Level level = this.entity.level();
        BlockPos entityPos = this.entity.blockPosition();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int entityX = entityPos.getX();
        int entityY = entityPos.getY();
        int entityZ = entityPos.getZ();
        for (int x = -10; x <= 10; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -10; z <= 10; ++z) {
                    mutablePos.set(entityX + x, entityY + y, entityZ + z);
                    Block block = level.getBlockState((BlockPos)mutablePos).getBlock();
                    if (!block.defaultBlockState().is(ModTags.Blocks.ATTRACTS_MOTH)) continue;
                    this.targetPos = mutablePos.immutable();
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isNearLightSource() {
        return this.targetPos != null && this.entity.blockPosition().closerThan((Vec3i)this.targetPos, 1.5);
    }
}

