/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.event;

import net.astralya.hexalia.block.ModBlocks;
import net.astralya.hexalia.particle.ModParticleType;
import net.astralya.hexalia.particle.custom.GhostParticle;
import net.astralya.hexalia.particle.custom.InfusedBubbleParticle;
import net.astralya.hexalia.particle.custom.LeavesParticle;
import net.astralya.hexalia.particle.custom.SporeParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

@EventBusSubscriber(modid="hexalia", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetUpEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticleType.GHOST.get(), GhostParticle.Factory::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticleType.INFUSED_BUBBLES.get(), InfusedBubbleParticle.Factory::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticleType.LEAVES.get(), LeavesParticle.Factory::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticleType.SPORE.get(), SporeParticle.Factory::new);
    }

    @SubscribeEvent
    public static void registerColoredBlocks(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos) : FoliageColor.getDefaultColor(), new Block[]{(Block)ModBlocks.COTTONWOOD_LEAVES.get(), (Block)ModBlocks.WILLOW_LEAVES.get()});
    }

    @SubscribeEvent
    public static void registerColoredItems(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            BlockState state = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
            return Minecraft.getInstance().getBlockColors().getColor(state, null, null, tintIndex);
        }, new ItemLike[]{(ItemLike)ModBlocks.COTTONWOOD_LEAVES.get(), (ItemLike)ModBlocks.WILLOW_LEAVES.get()});
    }
}

