/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.item.custom;

import java.util.function.Consumer;
import net.astralya.hexalia.item.custom.client.GhostVeilRenderer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class GhostVeilItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public GhostVeilItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private GeoArmorRenderer<?> renderer;

            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(T livingEntity, ItemStack stack, EquipmentSlot slot, HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = new GhostVeilRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, state -> {
            state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof Player)) {
            super.inventoryTick(stack, world, entity, slot, selected);
            return;
        }
        Player player = (Player)entity;
        boolean wearingThis = player.getItemBySlot(EquipmentSlot.CHEST).equals(stack);
        if (!world.isClientSide && wearingThis) {
            if (player.isCrouching()) {
                CustomData data;
                MobEffectInstance cur = player.getEffect(MobEffects.INVISIBILITY);
                if (cur == null || cur.getDuration() <= 10) {
                    player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 20, 0, false, false, false));
                }
                CompoundTag tag = (data = (CustomData)stack.get(DataComponents.CUSTOM_DATA)) != null ? data.copyTag() : new CompoundTag();
                tag.putBoolean("HexaliaInvisFromItem", true);
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                if (stack.isDamageableItem() && world.getGameTime() % 20L == 0L && !player.getAbilities().instabuild) {
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.CHEST);
                    if (stack.isEmpty()) {
                        player.setItemSlot(EquipmentSlot.CHEST, ItemStack.EMPTY);
                    }
                }
            } else {
                boolean fromItem = false;
                CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
                if (data != null) {
                    CompoundTag tag = data.copyTag();
                    fromItem = tag.getBoolean("HexaliaInvisFromItem");
                    tag.remove("HexaliaInvisFromItem");
                    if (tag.isEmpty()) {
                        stack.remove(DataComponents.CUSTOM_DATA);
                    } else {
                        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                    }
                }
                if (fromItem && player.hasEffect(MobEffects.INVISIBILITY)) {
                    player.removeEffect(MobEffects.INVISIBILITY);
                }
            }
        }
        super.inventoryTick(stack, world, entity, slot, selected);
    }
}

