/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.item.custom;

import net.astralya.hexalia.item.ModItems;
import net.astralya.hexalia.item.custom.AbstractConsumableItem;
import net.astralya.hexalia.util.TeleportUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;

public class HomesteadBrewItem
extends AbstractConsumableItem {
    public HomesteadBrewItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide && TeleportUtil.canReturn(level, player, true)) {
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        return super.use(level, player, hand);
    }

    @Override
    protected void handleEffects(Level level, LivingEntity user, ItemStack consumedStack) {
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        if (player instanceof FakePlayer) {
            return;
        }
        TeleportUtil.teleportPlayerToSpawn(level, player, true);
    }

    @Override
    protected ItemStack getReturnContainer(ItemStack consumedStack) {
        return new ItemStack((ItemLike)ModItems.RUSTIC_BOTTLE.get());
    }

    @Override
    protected Component getTooltip(ItemStack stack) {
        return Component.translatable((String)"tooltip.hexalia.homestead_brew").withStyle(ChatFormatting.BLUE);
    }
}

