/*
 * Decompiled with CFR 0.152.
 */
package net.astralya.hexalia.item.custom;

import java.util.Optional;
import net.astralya.hexalia.particle.ModParticleType;
import net.astralya.hexalia.recipe.ModRecipes;
import net.astralya.hexalia.recipe.MutationRecipe;
import net.astralya.hexalia.recipe.MutationRecipeInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MutavisItem
extends Item {
    public MutavisItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Optional<MutationRecipe> match;
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        ItemStack inputStack = new ItemStack((ItemLike)state.getBlock().asItem());
        if (inputStack.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide && (match = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.MUTATION_TYPE.get(), (RecipeInput)new MutationRecipeInput(inputStack), level).map(RecipeHolder::value)).isPresent()) {
            Player player;
            level.destroyBlock(pos, false);
            ServerLevel server = (ServerLevel)level;
            ItemStack out = match.get().assemble(new MutationRecipeInput(inputStack), (HolderLookup.Provider)server.registryAccess());
            if (!out.isEmpty()) {
                server.addFreshEntity((Entity)new ItemEntity((Level)server, (double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5, out.copy()));
            }
            if ((player = context.getPlayer()) != null && !player.getAbilities().instabuild) {
                context.getItemInHand().shrink(1);
            }
            this.emitEffects(server, pos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private void emitEffects(ServerLevel server, BlockPos pos) {
        server.playSound(null, pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 0.5f, 1.0f);
        server.sendParticles((ParticleOptions)ModParticleType.LEAVES.get(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, 15, 0.2, 0.25, 0.2, 0.0);
    }
}

